% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/participation.R
\name{participation}
\alias{participation}
\title{Participation Coefficient}
\usage{
participation(A, comm = c("walktrap", "louvain"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{comm}{A vector of corresponding to each item's community.
Defaults to \code{"walktrap"} for the \code{\link[igraph]{cluster_walktrap}} community detection algorithm.
Set to \code{"louvain"} for the \code{\link[NetworkToolbox]{louvain}} community detection algorithm.
Can also be set to user-specified communities (see examples)}
}
\value{
Returns a list containing:

\item{overall}{Participation coefficient without signs considered}

\item{positive}{Participation coefficient with only positive sign}

\item{negative}{Participation coefficient with only negative sign}
}
\description{
Computes the participation coefficient for each node. The participation
coefficient measures the strength of a node's connections within its community. Positive
and negative signed weights for participation coefficients are computed separately.
}
\details{
Values closer to 1 suggest greater within-community connectivity and 
values closer to 0 suggest greater between-community connectivity
}
\examples{
#theoretical factors
comm <- rep(1:8, each = 6)

# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

pc <- participation(A, comm = comm)

# Walktrap factors
wpc <- participation(A, comm = "walktrap")

}
\references{
Guimera, R., & Amaral, L. A. N. (2005).
Functional cartography of complex metabolic networks.
\emph{Nature}, \emph{433}, 895-900.

Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{NeuroImage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
