## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----setup2, message=FALSE-----------------------------------------------
require(NNS)
require(knitr)
require(rgl)
require(data.table)

## ----rhs, rows.print=18--------------------------------------------------
NNS.reg(iris[,1:4], iris[,5], residual.plot = FALSE, ncores = 1)$rhs.partitions

## ----NNSBOOST,fig.align = "center", fig.height = 8,fig.width=6.5---------
set.seed(123)
test.set = sample(150,10)

a = NNS.boost(iris[-test.set, 1:4], iris[-test.set, 5],
              IVs.test = iris[test.set, 1:4],
              epochs = 100, learner.trials = 100, status = FALSE,
              ncores = 1, subcores = 1)

mean(round(a)==as.numeric(iris[test.set,5]))

