% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{NNS.PDF}
\alias{NNS.PDF}
\title{NNS PDF}
\usage{
NNS.PDF(degree, variable, target = NULL, bins = NULL, plot = TRUE)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{variable}{a numeric vector.}

\item{target}{a numeric range of values [a,b] where a < b.  \code{NULL} (default) uses the \code{variable} observations.}

\item{bins}{numeric; \code{NULL} (default) Selects number of observations as default bins.}

\item{plot}{logical; plots PDF.}
}
\value{
vector representing PDF of a variable
}
\description{
This function generates an empirical PDF using continuous CDFs from \link{LPM.ratio}.
}
\examples{
set.seed(123)
x<-rnorm(100)
NNS.PDF(degree=1,x)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{CDF}
\keyword{PDF,}
\keyword{continuous}
\keyword{moments,}
\keyword{partial}
