% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multivariate_Regression.R
\name{VN.M.reg}
\alias{VN.M.reg}
\title{VN Multivariate Regression}
\usage{
VN.M.reg(B, y, order = 1, type = "XONLY", point.est = NULL,
  plot = FALSE, residual.plot = TRUE)
}
\arguments{
\item{B}{Complete dataset of independent variables (IV) in matrix form.}

\item{y}{Dependent variable (DV).}

\item{order}{Controls the number of the \code{VN.reg}.  Defaults to \code{order=1}.}

\item{type}{Controls the partitioning in \code{VN.reg}.  Defaults to \code{type="XONLY"} for IV based partitioning.   \code{type=NULL} for both IV and DV partitioning.}

\item{point.est}{Generates a fitted value of \code{y} for a vector or matrix of IV coordinates.}

\item{plot}{Generates a 3d scatter plot with regression points using \link{plot3d}}

\item{residual.plot}{Generates a \code{matplot} for Y.hat and Y}
}
\description{
Called by \code{VN.reg} for multivariate regression analysis.
}
\examples{
set.seed(123);size=30;x_1=rnorm(size,mean=5,sd=1);x_2=rnorm(size,mean=1,sd=5); x_3=runif(size)
y=x_1^2+x_2+x_3
B=cbind(x_1,x_2,x_3)
VN.M.reg(B,y)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{multiple}
\keyword{nonlinear}
\keyword{regression}

