% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-cluster.R
\name{validateCluster}
\alias{validateCluster}
\title{Validate the accuracy of our clustering of the projection comparing to users'
input.}
\usage{
validateCluster(dist_mat, extra_feature, community)
}
\arguments{
\item{dist_mat}{A matrix, the distance of graph, usually got from}

\item{extra_feature}{A dataframe has only one column indicating the
membership of each nodes (rownames).}

\item{community}{An igraph community object.}
}
\value{
A list containing the measured differences between clustering methods
and reference clustering, corrected rand index and Jaccard similarity.
}
\description{
This function will verify the similarity between different
clustering methods and external features (prior knowledge), which is to
measure the results of clustering methods.
}
\examples{
# load part of the beatAML data
data <- NIMAA::beatAML
# convert to incidence matrix
inc_mat <- el2IncMatrix(data, print_skim = FALSE)

# run findCluster() to do clustering
cls <- findCluster(
inc_mat,
dim = 1,
method = c('infomap','walktrap'),
normalization = FALSE,
rm_weak_edges = TRUE,
comparison = FALSE)

# generate some external_feature
external_feature <- data.frame(row.names = cls$infomap$names)
external_feature[,'membership'] <- paste('group',
sample(c(1,2,3,4),
nrow(external_feature),
replace = TRUE))

# validation
validateCluster(dist_mat = cls$distance_matrix,
community = cls$walktrap,
extra_feature = external_feature)
}
