% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{CommutatorIndx}
\alias{CommutatorIndx}
\title{Commutator Index}
\usage{
CommutatorIndx(Type, ...)
}
\arguments{
\item{Type}{a string specifying the type of commutator index to be calculated. Must be one of "Kmn", "Kperm", "Mixing", or "Moment".}

\item{...}{additional arguments passed to the specific commutator function.}
}
\value{
A vector representing the commutator index.
}
\description{
This function calculates the commutator index based on the specified type. The available types are "Kmn", "Kperm", "Mixing", and "Moment".
Depending on the selected type, the corresponding specific function is called.
}
\details{
The function `CommutatorIndx` acts as a wrapper to call specific commutator functions based on the input `Type`.

\strong{Type "Kmn"}:
\describe{
  \item{Parameters:}{
    \itemize{
      \item \code{m} - Row-dimension.
      \item \code{n} - Col-dimension.
    }
  }
  \item{Return:}{
    A vector of indexes to provide the commutation, transforming vec A to vec of the transposed A.
  }
}

\strong{Type "Kperm"}:
\describe{
  \item{Parameters:}{
    \itemize{
      \item \code{perm} - Vector indicating the permutation of the order in the Kronecker product.
      \item \code{dims} - Vector indicating the dimensions of the vectors.
    }
  }
  \item{Return:}{
    An index vector to produce the permutation of the Kronecker products of vectors of any length.
  }
}

\strong{Type "Mixing"}:
\describe{
  \item{Parameters:}{
    \itemize{
      \item \code{x} - A vector of dimension \code{prod(d1)*prod(d2)}.
      \item \code{d1} - Dimension of the first group of vectors.
      \item \code{d2} - Dimension of the second group of vectors.
    }
  }
  \item{Return:}{
    A vector Kx representing the product of the moment commutator and the vector x.
  }
}

\strong{Type "Moment"}:
\describe{
  \item{Parameters:}{
    \itemize{
      \item \code{x} - A vector of length \code{d^n} where n is the length of \code{el_rm}.
      \item \code{el_rm} - Type of a partition.
      \item \code{d} - Dimensionality of the underlying multivariate distribution.
    }
  }
  \item{Return:}{
    A vector Kx representing the product of the moment commutator and the vector x.
  }
}
}
\examples{
# Kmn example
A <- 1:6
CommutatorIndx(Type = "Kmn", m = 3, n = 2)

# Kperm example
a1 <- c(1, 2)
a2 <- c(2, 3, 4)
a3 <- c(1, 3)
p1 <- a1 \%x\% a2 \%x\% a3
CommutatorIndx(Type = "Kperm", perm = c(3, 1, 2), dims = c(2, 3, 2))

# Mixing example
d1 <- c(2, 3, 2)
d2 <- c(3, 2, 2)
x <- 1:(prod(d1) * prod(d2))
CommutatorIndx(Type = "Mixing", x = x, d1 = d1, d2 = d2)

# Moment example
n <- 4
r <- 2
m <- 1
d <- 2
PTA <- PartitionTypeAll(n)
el_r <- PTA$eL_r[[r]][m, ]
x <- 1:d^n
CommutatorIndx(Type = "Moment", x = x, el_rm = el_r, d = d)

}
\seealso{
Other Commutators: 
\code{\link{CommutatorMatr}()}
}
\concept{Commutators}
