% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAHMD.R
\name{ReadAHMD}
\alias{ReadAHMD}
\title{Download the Australian Human Mortality Database (AHMD)}
\usage{
ReadAHMD(what, regions = NULL, interval = "1x1", save = FALSE, show = TRUE)
}
\arguments{
\item{what}{What type of data are you looking for? The following options
might be available for some or all the countries and regions: \itemize{
  \item{\code{"births"}} -- birth records;
  \item{\code{"Dx_lexis"}} -- deaths by Lexis triangles;
  \item{\code{"Ex_lexis"}} -- exposure-to-risk by Lexis triangles;
  \item{\code{"population"}} -- population size;
  \item{\code{"Dx"}} -- death counts;
  \item{\code{"Ex"}} -- exposure-to-risk;
  \item{\code{"mx"}} -- central death-rates;
  \item{\code{"LT_f"}} -- period life tables for females;
  \item{\code{"LT_m"}} -- period life tables for males;
  \item{\code{"LT_t"}} -- period life tables both sexes combined;
  \item{\code{"e0"}} -- period life expectancy at birth;
  \item{\code{"Exc"}} -- cohort exposures;
  \item{\code{"mxc"}} -- cohort death-rates;
  \item{\code{"LT_fc"}} -- cohort life tables for females;
  \item{\code{"LT_mc"}} -- cohort life tables for males;
  \item{\code{"LT_tc"}} -- cohort life tables both sexes combined;
  \item{\code{"e0c"}} -- cohort life expectancy at birth;
  }}

\item{regions}{Specify the region specific data you want to download by
adding the AHMD region code/s. Options:
\itemize{
  \item{\code{"ACT"}} -- Australian Capital Territory;
  \item{\code{"NSW"}} -- New South Wales;
  \item{\code{"NT"}} -- Northern Territory;
  \item{\code{"QLD"}} -- Queensland;
  \item{\code{"SA"}} -- South Australia;
  \item{\code{"TAS"}} -- Tasmania;
  \item{\code{"VIC"}} -- Victoria;
  \item{\code{"WA"}} -- Western Australia;
  \item{\code{NULL}} -- if \code{NULL} data for all the regions are downloaded.
  }}

\item{interval}{Datasets are given in various age and time formats based on
which the records are agregated. Interval options:
\itemize{
  \item{\code{"1x1"}} -- by age and year;
  \item{\code{"1x5"}} -- by age and 5-year time interval;
  \item{\code{"1x10"}} -- by age and 10-year time interval;
  \item{\code{"5x1"}} -- by 5-year age group and year;
  \item{\code{"5x5"}} -- by 5-year age group and 5-year time interval;
  \item{\code{"5x10"}} --by 5-year age group and 10-year time interval.
  }}

\item{save}{Do you want to save a copy of the dataset on your local machine?
Logical. Default: \code{FALSE}.}

\item{show}{Choose whether to display a progress bar. Logical.
Default: \code{TRUE}.}
}
\value{
A \code{ReadAHMD} object that contains:
 \item{input}{List with the input values;}
 \item{data}{Data downloaded from AHMD;}
 \item{download.date}{Time stamp;}
 \item{years}{Numerical vector with the years covered in the data;}
 \item{ages}{Numerical vector with ages covered in the data.}
}
\description{
Download detailed mortality and population data for different
provinces and territories in Australia, in a single object from the
\href{http://demography.cass.anu.edu.au/research/australian-human-mortality-database}{
Australian Human Mortality Database}.
}
\details{
(Description taken from the AHMD website).

The Australian Human Mortality Database (AHMD) was created to provide
detailed Australian mortality and population data to researchers, students,
journalists, policy analysts, and others interested in the history of
human longevity. The project is an achievement of the Mortality,
Ageing & Health research team in the ANU School of Demography under the
supervision of Associate Professor Vladimir Canudas-Romo, in collaboration
with demographers at the Max Plank Institute for Demographic Research
(Rostock, Germany) and the Department of Demography, University of
California at Berkeley.

The AHMD is a "satellite" of the Human Mortality Database (HMD),
an international database which currently holds detailed data for multiple
countries or regions. Consequently, the AHMD's underlying methodology
corresponds to the one used for the HMD.

The AHMD gathers all required data (deaths counts, births counts,
population size, exposure-to-risk, death rates) to compute life tables
for Australia, its states and its territories. One of the great advantages
of the database is to include data that is validated and corrected, when
required, and rendered comparable, if possible, for the period ranging
from 1971 thru 2016. For comparison purposes, various life tables published
by governmental organizations are also available for download in PDF format.
}
\examples{
\dontrun{
# Download demographic data for Australian Capital Territory and
# Tasmania regions in 5x1 format

# Death counts. We don't want to export data outside R.
AHMD_Dx <- ReadAHMD(what = "Dx",
                    regions = c('ACT', 'TAS'),
                    interval  = "5x1",
                    save = FALSE)
ls(AHMD_Dx)
AHMD_Dx

# Download life tables for female population in all the states and export data.
LTF <- ReadAHMD(what = "LT_f", interval  = "5x1", save = TRUE)
LTF
}
}
\seealso{
\code{\link{ReadHMD}}
\code{\link{ReadCHMD}}
}
\author{
Marius D. Pascariu
}
