% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{rescale}
\alias{rescale}
\title{Rescale coordinates from pixels to real length units}
\usage{
rescale(x, scaling_factor, scale_mapping, magnification_col, ...)
}
\arguments{
\item{x}{any \code{Coo} object}

\item{scaling_factor}{numeric an homogeneous scaling factor. If all you (x, y) coordinates
have the same scale}

\item{scale_mapping}{either a data.frame or a path to read such a data.frame. It MUST contain
three columns in that order: magnification found in \verb{$fac}, column \code{"magnification_col"}, pixels, real length unit.
Column names do not matter but must be specified, as read.table reads with \code{header=TRUE} Every
different magnification level found in \verb{$fac}, column \code{"magnification_col"} must have its row.}

\item{magnification_col}{the name or id of the $fac column to look for magnification levels for every image}

\item{...}{additional arguments (besides header=TRUE) to pass to read.table if 'scale_mapping' is a path}
}
\description{
Most of the time, (x, y) coordinates are recorded in pixels. If we want to have
them in mm, cm, etc. we need to convert them and to rescale them. This functions
does the job for the two cases: i) either an homogeneous rescaling factor,
e.g. if all pictures were taken using the very same magnification or ii) with various
magnifications. More in the Details section
}
\details{
The i) case above is straightforward, if 1cm is 500pix long on all your pictures,
just call \code{rescale(your_Coo, scaling_factor=1/500)} and all coordinates will be in cm.

The ii) second case is more subtle. First you need to code in your /link{Coo} object, in the fac
slot, a column named, say "mag", for magnification. Imagine you have 4 magnifications: 0.5, 1, 2 and 5,
we have to indicate for each magnification, how many pixels stands for how many units in the real world.

This information is passed as a data.frame, built externally or in R, that must look like this:
\preformatted{
mag   pix    cm
0.5   1304   10
1     921    10
2     816    5
5     1020   5
}.

We have to do that because, for optical reasons, the ratio pix/real_unit, is not a linear
function of the magnification.

All shapes will be centered to apply (the single or the different) scaling_factor.
}
\note{
This function is simple but quite complex to detail. Feel free to contact me should you have any
problem with it. You can just access its code (type \code{rescale}) and reply it yourself.
}
\seealso{
Other handling functions: 
\code{\link{arrange}()},
\code{\link{at_least}()},
\code{\link{chop}()},
\code{\link{combine}()},
\code{\link{dissolve}()},
\code{\link{fac_dispatcher}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{rm_harm}()},
\code{\link{rm_missing}()},
\code{\link{rm_uncomplete}()},
\code{\link{rw_fac}()},
\code{\link{sample_frac}()},
\code{\link{sample_n}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{subsetize}()}
}
\concept{handling functions}
