% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.effect.freq.R
\name{get.effect.freq}
\alias{get.effect.freq}
\title{Compute marker frequency in QTL-markers}
\usage{
get.effect.freq(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  sort = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{sort}{Set to FALSE to not sort markers according to position on the genome}
}
\value{
Matrix with allele frequencies in the QTLs
}
\description{
Function to compute marker frequency in QTL-markers
}
\examples{
data(ex_pop)
get.effect.freq(ex_pop, gen=1)
}
