% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterGamma.R
\docType{methods}
\name{plot,ClusterGamma-method}
\alias{plot,ClusterGamma-method}
\alias{plot-ClusterGamma,}
\alias{ClusterGamma-method}
\title{Plotting of a class [\code{\linkS4class{ClusterGamma}}]}
\usage{
\S4method{plot}{ClusterGamma}(x, y, ...)
}
\arguments{
\item{x}{an object of class [\code{\linkS4class{ClusterGamma}}]}

\item{y}{a list of variables to plot (subset). Variables names or indices.
If missingValues all the variables are represented.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plotting data from a [\code{\linkS4class{ClusterGamma}}] object
using the estimated parameters and partition.
}
\examples{
\donttest{
  ## Example with quantitative vairables
  data(iris)
  model <- clusterGamma( data=iris[1:4], nbCluster=3
                       , models=clusterGammaNames(prop = "equal")
                       , strategy = clusterFastStrategy())
  plot(model)
  plot(model, c(1,3))
  plot(model, c("Sepal.Length","Sepal.Width"))
  }

}
\seealso{
\code{\link{plot}}
}
