% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterMixedData.R
\name{clusterMixedData}
\alias{clusterMixedData}
\title{Create an instance of the [\code{\linkS4class{ClusterMixedDataModel}}] class}
\usage{
clusterMixedData(
  data,
  models,
  nbCluster = 2,
  strategy = clusterStrategy(),
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{data}{[\code{list}] containing the data sets (matrices and/or data.frames).
If data sets contain NA values, these missing values will be estimated during
the estimation process.}

\item{models}{a [\code{vector}] of character or a [\code{list}] of
same length than data. It contains the model names to use in order to fit
each data set.}

\item{nbCluster}{[\code{\link{vector}}] with the number of clusters to test.}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. Default is clusterStrategy().}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterMixedDataModel}}] class.
}
\description{
This function computes the optimal mixture model for mixed data according
to the \code{criterion} among the number of clusters given in
\code{nbCluster} using the strategy specified in [\code{strategy}].
}
\examples{
## A quantitative example with the heart disease data set
data(HeartDisease.cat)
data(HeartDisease.cont)
## with default values
ldata = list(HeartDisease.cat, HeartDisease.cont);
models = c("categorical_pk_pjk","gaussian_pk_sjk")
model <- clusterMixedData(ldata, models, nbCluster=2:5, strategy = clusterFastStrategy())

## get summary
summary(model)

## get estimated missing values
missingValues(model)

\donttest{
## print model (a very detailed output)
print(model)
## use graphics functions
plot(model)
}

}
\author{
Serge Iovleff
}
