% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmm.R
\docType{class}
\name{KmmComponent}
\alias{KmmComponent}
\alias{KmmComponent-class}
\title{Definition of the [\code{\linkS4class{KmmComponent}}] class}
\description{
This class defines a kernel component of a mixture Model. It inherits
from [\code{\linkS4class{IClusterComponent}}].
}
\section{Slots}{

\describe{
\item{\code{dim}}{Vector with the dimension of the kth cluster}

\item{\code{sigma2}}{Vector with the standard deviation in the kth cluster.}

\item{\code{gram}}{Matrix storing the gram matrix if its computation is needed}

\item{\code{kernelName}}{string with the name of the kernel to use. Possible values:
"Gaussian", "polynomial", "Laplace", "linear","rationalQuadratic", "Hamming".
Default is "Gaussian".}

\item{\code{kernelParameters}}{vector with the parameters of the kernel.}

\item{\code{kernelComputation}}{boolean value set as \code{TRUE} if Gram matrix is to be computed
\code{FALSE} othewise. Default is \code{TRUE}.}
}}

\examples{
getSlots("KmmComponent")

}
\seealso{
[\code{\linkS4class{IClusterComponent}}] class
}
\author{
Serge Iovleff
}
