#'Select matrix columns based on values of attendant vector
#'
#'This function selects columns of a matrix that correspond to 1 or 2 factor levels of attendant vector.
#'
#'@param Matrix matrix
#'@param specimens factor vector with length equal to number of \code{Matrix} columns
#'@param group1 value of factor level to sample
#'@param group2 additional value of factor level to sample
#'
#'@details
#' This function is ment for sampling specimens in  gene/transcript expression matrix for binary classification
#' in case when specimens belong to more than two groups. The aim is to create gene/transcript expression
#' matrix that contains specimens for only 1 or 2 groups.
#' Groups are specified in corresponding factor vector that contains specimens description.
#' It should be used together with \code{\link{MiSpecimenSample}} that samples specimens'
#' description in the same way.
#'
#'@return \code{Matrix} with rescricted number of columns that correspond to specimens from 1 or 2 groups.
#'
#'@examples
#'
#' #get gene expression and specimen data
#' data("IMexpression");data("IMspecimen")
#' dim(IMexpression) # 100 columns (genes/transcripts) - 89 specimens
#' colnames(IMexpression)[1:10] # look at first 10 columns of matrix - specimens IDs
#' IMspecimen[1:10,] # specimens IDs and group factor - diagnoses in attendant vector
#' # note that specimens in matrix columns are in the same order as specimens in description data
#' # select specimens with only EBV and NORM diagnoses (and sample the description data as well)
#' SampleMatrix<-MiDataSample(IMexpression, IMspecimen$diagnosis, "ebv", "norm")
#' SampleSamples<-MiSpecimenSample(IMspecimen$diagnosis, "ebv", "norm")
#' dim(SampleMatrix)# only 68 specimens with EBV and NORM diagnoses left
#' colnames(SampleMatrix)[1:10]
#' SampleSamples[1:10] # corresponding diagnoses
#'
#'@author Elena N. Filatova
#'
#'@seealso \code{\link{MiSpecimenSample}}
#'
#'@export


MiDataSample <- function(Matrix, specimens, group1, group2=NULL){
  colid <- specimens %in% c(group1, group2)
  datamat <- Matrix[, colid]
  return(datamat)
  }
