% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mimids.R
\name{print.mimids}
\alias{print.mimids}
\title{Prints a \code{mimids} Class Object}
\usage{
\method{print}{mimids}(x, n = 1, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{This argument specifies an object of the \code{mimids} class.}

\item{n}{This argument specifies the matched imputed dataset number, intended to print its matching profile. The input must be a positive integer. The default is \code{1}.}

\item{digits}{This argument specifies minimal number of significant digits.}

\item{...}{Additional arguments to be passed to the \code{print.mimids()} function.}
}
\description{
The \code{print.mimids()} function prints an object of the \code{mimids} class.
}
\details{
The matching profile of the \code{mimids} class objects is printed.
}
\examples{
\donttest{
#Loading the 'dt.osa' dataset
data(dt.osa)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(KOA ~ SEX + AGE + SMK, datasets,
                               approach = 'within', method = 'exact')

#Printing data of the first imputed dataset
print.1 <- print(matcheddatasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=mimids]{mimids}}
}
\author{
Farhad Pishgar
}
\keyword{function}
