% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_filter_feat.R
\name{mi_filter_feat}
\alias{mi_filter_feat}
\title{Performing feature selection in a automatic way based on correlation and feature importance.}
\usage{
mi_filter_feat(data, cor_thresh = 0.7, imp_thresh = 0.99, union = FALSE)
}
\arguments{
\item{data}{The data frame returned by \code{mi_to_numer()}.}

\item{cor_thresh}{The threshold set for Pearson correlation. If correlation value is over this threshold, the two features will be viewed as redundant and one of them will be removed.}

\item{imp_thresh}{The threshold set for feature importance. The last several features with the lowest importance will be removed if remained importance lower than \code{imp_thresh}.}

\item{union}{The method for combining the decisions of correlation method and importance method. If \code{TRUE}, any of the features calculated by the two methods will be returned. Otherwise, only features in the results of both methods will be returned.}
}
\value{
The names of the features that should be removed.
}
\description{
Performing feature selection in a automatic way based on correlation and feature importance.
}
