% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{get.solver.params}
\alias{get.solver.params}
\title{Get parameters to initialize solver}
\usage{
get.solver.params(
  isconvex = FALSE,
  DEBUG = 0,
  Tolerance = 1e-04,
  Max_Iteration = 1000,
  IsCheckParams = FALSE,
  IsCheckGradHess = FALSE,
  ...
)
}
\arguments{
\item{isconvex}{Indicator for whether the function is convex (TRUE or FALSE)}

\item{DEBUG}{Verbosity level in \{0,1,2,3\}. Use 0 for quietest with no
messages printed. Use 3 for most verbose,}

\item{Tolerance}{Tolerance used to assess convergence. See Huang et al
(2016b) for details on how this is used,}

\item{Max_Iteration}{Maximum iterations to be used by the solver
(a non-negative integer),}

\item{IsCheckParams}{Should solver check inputs and print summary message
before optimization (TRUE or FALSE),}

\item{IsCheckGradHess}{Check correctness of the gradient and Hessian
functions (TRUE or FALSE).}

\item{...}{Additional arguments to pass to the solver. These are not
validated by the \code{get.solver.params} function. Users should 
refer to the C++ library's user manual for available arguments.}
}
\value{
List containing input arguments for solver
}
\description{
Get parameters to initialize solver
}
\details{
Solver-specific parameters may also be added to the object returned
from \code{get.solver.params}, via standard list manipulation. Interested
users should refer to Huang et al (2016b) for available options.
}
\references{
Wen Huang, P.A. Absil, K.A. Gallivan, Paul Hand (2016a). "ROPTLIB: an
object-oriented C++ library for optimization on Riemannian manifolds."
Technical Report FSU16-14, Florida State University.

Wen Huang, Kyle A. Gallivan, and P.A. Absil (2016b).
Riemannian Manifold Optimization Library.
URL \url{http://www.math.fsu.edu/~whuang2/pdf/USER_MANUAL_for_2016-04-29.pdf}

S. Martin, A. Raim, W. Huang, and K. Adragni (2020). "ManifoldOptim: 
An R Interface to the ROPTLIB Library for Riemannian Manifold Optimization."
Journal of Statistical Software, 93(1):1-32.
}
