% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_index.R
\name{col_index}
\alias{col_index}
\title{A function indexing the columns of A}
\usage{
col_index(M, x)
}
\arguments{
\item{M}{A vector of positive integers giving the alphabet sizes of the discrete variables.}

\item{x}{An element of the joint space.}
}
\value{
A positive integer no greater than the cardinality of the joint space uniquely identifying \code{x}.
}
\description{
A map from the joint space to an index set.
}
\examples{
M=c(2,2,2)
col_index(M,c(1,1,1))
col_index(M,c(1,1,2))

M=c(4,3,2)
col_index(M,c(1,1,1))
col_index(M,c(2,1,1))
col_index(M,c(1,2,1))
col_index(M,c(1,1,2))
}
