% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inconsistency.functions.R
\name{get.relative}
\alias{get.relative}
\title{Calculates relative effects between treatments in an MBNMA model}
\usage{
get.relative(mbnma, treatments = list())
}
\arguments{
\item{mbnma}{An object of \code{class("mbnma")}}

\item{treatments}{A list whose elements each represent different treatments.
Treatment is defined as a combination of agent and dose. Only agents specified in
\code{mbnma} can be included. Each element in \code{treatments} is named corresponding to the
agent and contains a numeric vector of doses. Relative effects will be calculated between
all treatments specified in \code{treatments}.}
}
\value{
An array of \verb{length(treatments) x length(treatments) x nsims}, where \code{nsims}
is the number of iterations monitored in \code{mbnma}. The array contains the individual
MCMC values for each relative effect calculated between all \code{treatments}. The
direction of effect is for the row-defined treatment versus the column-defined
treatment.
}
\description{
Calculates relative effects between treatments in an MBNMA model
}
\examples{
# Using the osteoarthritis data
network <- mbnma.network(osteopain_2wkabs)

expon <- mbnma.exponential(network, method="random")

# Calculate relative effects between:
# Celebrex 100mg/d, Celebrex 200mg/d, Tramadol 100mg/d
rel.eff <- get.relative(expon, treatments=list("Celebrex"=c(100,200), "Tramadol"=100))

}
