/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import uk.ac.rhul.cs.cl1.AbstractNodeSetMerger;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.SimilarityFunction;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSetList;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.utils.HashMultimap;
import uk.ac.rhul.cs.utils.Multiset;
import uk.ac.rhul.cs.utils.StringUtils;
import uk.ac.rhul.cs.utils.TreeMultiset;
import uk.ac.rhul.cs.utils.UnorderedPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPassNodeSetMerger
extends AbstractNodeSetMerger {
    private TreeMap<Integer, Integer> counts = new TreeMap();
    protected boolean debugging = false;
    protected VerificationMode verificationMode = VerificationMode.VERIFY_AND_MINIMIZE;

    public boolean isDebugging() {
        return this.debugging;
    }

    public boolean isVerificationMode() {
        return this.verificationMode != VerificationMode.OFF;
    }

    @Override
    public ValuedNodeSetList mergeOverlapping(ValuedNodeSetList nodeSets, SimilarityFunction<NodeSet> similarityFunc, double threshold) {
        double similarity;
        int n = nodeSets.size();
        long stepsTotal = n * (n - 1) / 2;
        long stepsTaken = 0L;
        ValuedNodeSetList result = new ValuedNodeSetList();
        HashSet<Object> activeNodesets = new HashSet<Object>();
        if (n == 0) {
            return result;
        }
        if (this.isVerificationMode()) {
            this.prepareForVerification(nodeSets);
        }
        Graph graph = ((ValuedNodeSet)nodeSets.get(0)).getGraph();
        PriorityQueue<NodeSetPair> pairs = new PriorityQueue<NodeSetPair>();
        HashMultimap<ValuedNodeSet, NodeSetPair> nodesetsToPairs = new HashMultimap<ValuedNodeSet, NodeSetPair>();
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Finding highly overlapping clusters...");
        }
        for (int i = 0; i < n; ++i) {
            ValuedNodeSet v1 = (ValuedNodeSet)nodeSets.get(i);
            for (int j = i + 1; j < n; ++j) {
                ValuedNodeSet v2 = (ValuedNodeSet)nodeSets.get(j);
                similarity = similarityFunc.getSimilarity(v1, v2);
                if (!(similarity > 0.0)) continue;
                NodeSetPair pair = new NodeSetPair(v1, v2, similarity);
                pairs.add(pair);
                nodesetsToPairs.put(v1, pair);
                nodesetsToPairs.put(v2, pair);
            }
            if (!nodesetsToPairs.containsKey(v1)) {
                result.add(v1);
            }
            if ((stepsTaken += (long)(n - i - 1)) > stepsTotal) {
                stepsTaken = stepsTotal;
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted((int)(100.0f * ((float)stepsTaken / (float)stepsTotal)));
        }
        activeNodesets.addAll(nodesetsToPairs.keySet());
        if (this.debugging) {
            System.err.println("Nodesets with no similar pairs:");
            System.err.println(result);
            System.err.println("Overlapping pairs to consider:");
            System.err.println(pairs);
        }
        if (this.isVerificationMode()) {
            ValuedNodeSetList tmpResult = new ValuedNodeSetList();
            tmpResult.addAll(result);
            tmpResult.addAll(activeNodesets);
            this.verifyResult(tmpResult, similarityFunc, -1.0);
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Merging highly overlapping clusters...");
        }
        stepsTotal = pairs.size();
        stepsTaken = 0L;
        while (!pairs.isEmpty()) {
            NodeSetPair newPair;
            ValuedNodeSet v3;
            int member;
            Iterator<Object> i$;
            NodeSetPair pair = (NodeSetPair)pairs.poll();
            ValuedNodeSet v1 = (ValuedNodeSet)pair.getLeft();
            ValuedNodeSet v2 = (ValuedNodeSet)pair.getRight();
            if (pair.similarity < threshold) break;
            this.debug("Merging pair: " + pair);
            if (!activeNodesets.contains(v1)) {
                this.debug("  " + v1 + " already absorbed in another nodeset, skipping.");
                nodesetsToPairs.remove(v2, pair);
                continue;
            }
            if (!activeNodesets.contains(v2)) {
                this.debug("  " + v2 + " already absorbed in another nodeset, skipping.");
                nodesetsToPairs.remove(v1, pair);
                continue;
            }
            nodesetsToPairs.remove(v1, pair);
            nodesetsToPairs.remove(v2, pair);
            TreeMultiset<Integer> unionMembers = new TreeMultiset<Integer>();
            unionMembers.addAll(v1.getMembers());
            unionMembers.addAll(v2.getMembers());
            ValuedNodeSet unionNodeset = new ValuedNodeSet(graph, unionMembers.elementSet());
            for (Multiset.Entry entry : unionMembers.entrySet()) {
                Integer elt = (Integer)entry.getElement();
                int count = v1.getValue(elt, 0) + v2.getValue(elt, 0);
                unionNodeset.setValue(elt, count);
            }
            boolean v1SubsetOfv2 = unionNodeset.equals(v2);
            boolean v2SubsetOfv1 = unionNodeset.equals(v1);
            if (!v1SubsetOfv2 && !v2SubsetOfv1) {
                NodeSetPair newPair2;
                ValuedNodeSet v32;
                this.debug("v1 and v2 are not subsets of each other.");
                for (NodeSetPair oldPair : nodesetsToPairs.get(v1)) {
                    v32 = oldPair.getOtherThan(v1);
                    similarity = similarityFunc.getSimilarity(unionNodeset, v32);
                    nodesetsToPairs.remove(v32, oldPair);
                    if (similarity == 0.0) continue;
                    newPair2 = new NodeSetPair(unionNodeset, v32, similarity);
                    this.debug("  (1) updating pair: " + oldPair + " --> " + newPair2);
                    pairs.add(newPair2);
                    nodesetsToPairs.put(unionNodeset, newPair2);
                    nodesetsToPairs.put(v32, newPair2);
                }
                for (NodeSetPair oldPair : nodesetsToPairs.get(v2)) {
                    v32 = oldPair.getOtherThan(v2);
                    if (unionNodeset == v32) continue;
                    similarity = similarityFunc.getSimilarity(unionNodeset, v32);
                    nodesetsToPairs.remove(v32, oldPair);
                    if (similarity == 0.0) continue;
                    newPair2 = new NodeSetPair(unionNodeset, v32, similarity);
                    this.debug("  (2) updating pair: " + oldPair + " --> " + newPair2);
                    pairs.add(newPair2);
                    nodesetsToPairs.put(unionNodeset, newPair2);
                    nodesetsToPairs.put(v32, newPair2);
                }
                nodesetsToPairs.removeAll(v1);
                nodesetsToPairs.removeAll(v2);
                activeNodesets.remove(v1);
                activeNodesets.remove(v2);
                activeNodesets.add(unionNodeset);
            } else if (v1SubsetOfv2 && !v2SubsetOfv1) {
                this.debug("  v1 is a real subset of v2.");
                i$ = v1.iterator();
                while (i$.hasNext()) {
                    member = (Integer)i$.next();
                    v2.setValue(member, v1.getValue(member) + v2.getValue(member));
                }
                Collection v2Pairs = nodesetsToPairs.get(v2);
                for (NodeSetPair oldPair : nodesetsToPairs.get(v1)) {
                    v3 = oldPair.getOtherThan(v1);
                    nodesetsToPairs.remove(v3, oldPair);
                    if (v3 == v2) continue;
                    similarity = similarityFunc.getSimilarity(v2, v3);
                    this.debug("  Similarity of {" + v2 + "} and {" + v3 + "} is " + similarity);
                    if (similarity == 0.0) continue;
                    newPair = new NodeSetPair(v2, v3, similarity);
                    if (v2Pairs.contains(newPair)) {
                        this.debug("  This pair is already among v2's pairs, skipping.");
                        continue;
                    }
                    this.debug("  (3) updating pair: " + oldPair + " --> " + newPair);
                    pairs.add(newPair);
                    nodesetsToPairs.put(v2, newPair);
                    nodesetsToPairs.put(v3, newPair);
                }
                nodesetsToPairs.removeAll(v1);
                activeNodesets.remove(v1);
            } else if (v2SubsetOfv1 && !v1SubsetOfv2) {
                this.debug("  v2 is a real subset of v1.");
                i$ = v2.iterator();
                while (i$.hasNext()) {
                    member = (Integer)i$.next();
                    v1.setValue(member, v2.getValue(member) + v1.getValue(member));
                }
                Collection v1Pairs = nodesetsToPairs.get(v1);
                for (NodeSetPair oldPair : nodesetsToPairs.get(v2)) {
                    v3 = oldPair.getOtherThan(v2);
                    nodesetsToPairs.remove(v3, oldPair);
                    if (v3 == v1 || (similarity = similarityFunc.getSimilarity(v1, v3)) == 0.0 || v1Pairs.contains(newPair = new NodeSetPair(v1, v3, similarity))) continue;
                    this.debug("  (4) updating pair: " + oldPair + " --> " + newPair);
                    pairs.add(newPair);
                    nodesetsToPairs.put(v1, newPair);
                    nodesetsToPairs.put(v3, newPair);
                }
                nodesetsToPairs.removeAll(v2);
                activeNodesets.remove(v2);
            } else {
                this.debug("  v1 and v2 are identical.");
                i$ = v2.iterator();
                while (i$.hasNext()) {
                    member = (Integer)i$.next();
                    v1.setValue(member, v2.getValue(member) + v1.getValue(member));
                }
                nodesetsToPairs.removeAll(v2);
                activeNodesets.remove(v2);
            }
            if (this.isVerificationMode()) {
                ValuedNodeSetList tmpResult = new ValuedNodeSetList();
                tmpResult.addAll(result);
                tmpResult.addAll(activeNodesets);
                try {
                    this.verifyResult(tmpResult, similarityFunc, -1.0);
                }
                catch (RuntimeException ex) {
                    System.err.println("Step " + stepsTaken + "\n" + "Verification failed after merging:\n" + v1 + "\nand:\n" + v2);
                    if (this.verificationMode == VerificationMode.VERIFY_AND_MINIMIZE) {
                        System.err.println("Minimal subset that also fails:");
                        System.err.println(MultiPassNodeSetMerger.getMinimalSubsetThatFails(nodeSets, similarityFunc, threshold));
                    }
                    throw ex;
                }
            }
            ++stepsTaken;
        }
        result.addAll(activeNodesets);
        if (this.isVerificationMode()) {
            try {
                this.verifyResult(result, similarityFunc, threshold);
            }
            catch (RuntimeException ex) {
                if (this.verificationMode == VerificationMode.VERIFY_AND_MINIMIZE) {
                    System.err.println("\nMinimal subset that also fails:");
                    for (ValuedNodeSet ns : MultiPassNodeSetMerger.getMinimalSubsetThatFails(nodeSets, similarityFunc, threshold)) {
                        System.err.println(StringUtils.join(ns.getMembers(), " "));
                    }
                }
                throw ex;
            }
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(100);
        }
        return result;
    }

    private void prepareForVerification(ValuedNodeSetList input) {
        this.counts.clear();
        for (ValuedNodeSet nodeSet : input) {
            for (int member : nodeSet) {
                if (this.counts.containsKey(member)) {
                    this.counts.put(member, this.counts.get(member) + 1);
                    continue;
                }
                this.counts.put(member, 1);
            }
        }
    }

    private void verifyResult(ValuedNodeSetList result, SimilarityFunction<NodeSet> similarityFunc, double threshold) {
        TreeMap<Integer, Integer> newCounts = new TreeMap<Integer, Integer>();
        newCounts.clear();
        for (ValuedNodeSet nodeSet : result) {
            for (int member : nodeSet) {
                if (newCounts.containsKey(member)) {
                    newCounts.put(member, (Integer)newCounts.get(member) + 1);
                    continue;
                }
                newCounts.put(member, 1);
            }
        }
        if (!((Object)newCounts.keySet()).equals(this.counts.keySet())) {
            Graph graph = ((ValuedNodeSet)result.get(0)).getGraph();
            Set<Integer> ks = this.counts.keySet();
            StringBuilder sb = new StringBuilder("Nodes only in counts:");
            ks.removeAll(newCounts.keySet());
            for (int k : ks) {
                sb.append(" " + graph.getNodeName(k));
            }
            sb.append("\n");
            ks = newCounts.keySet();
            sb.append("Nodes only in newCounts:");
            ks.removeAll(this.counts.keySet());
            for (int k : ks) {
                sb.append(" " + graph.getNodeName(k));
            }
            throw new RuntimeException("newCounts and counts is different!\n" + sb.toString());
        }
        if (threshold < 0.0) {
            return;
        }
        for (ValuedNodeSet nodeSet1 : result) {
            for (ValuedNodeSet nodeSet2 : result) {
                double sim;
                if (nodeSet1 == nodeSet2 || !((sim = similarityFunc.getSimilarity(nodeSet1, nodeSet2)) >= threshold)) continue;
                throw new RuntimeException("similarity of " + nodeSet1 + " and " + nodeSet2 + " is " + sim + ", while the threshold is " + threshold);
            }
        }
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public void setVerificationMode(VerificationMode verificationMode) {
        this.verificationMode = verificationMode;
    }

    private void debug(String message) {
        if (!this.debugging) {
            return;
        }
        System.err.println(message);
    }

    public static ValuedNodeSetList getMinimalSubsetThatFails(ValuedNodeSetList nodeSets, SimilarityFunction<NodeSet> similarityFunc, double threshold) {
        boolean changed = true;
        MultiPassNodeSetMerger merger = new MultiPassNodeSetMerger();
        merger.setDebugging(false);
        merger.setVerificationMode(VerificationMode.VERIFY);
        try {
            ValuedNodeSetList result = merger.mergeOverlapping(nodeSets, similarityFunc, threshold);
            return null;
        }
        catch (RuntimeException ex) {
            ValuedNodeSetList result = (ValuedNodeSetList)nodeSets.clone();
            block6: while (changed && !result.isEmpty()) {
                changed = false;
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    ValuedNodeSet nodeSet = (ValuedNodeSet)it.next();
                    boolean failing = false;
                    ValuedNodeSetList nodeSetsCopy = (ValuedNodeSetList)result.clone();
                    nodeSetsCopy.remove(nodeSet);
                    try {
                        merger.mergeOverlapping(nodeSetsCopy, similarityFunc, threshold);
                    }
                    catch (RuntimeException ex2) {
                        failing = true;
                    }
                    if (!failing) continue;
                    it.remove();
                    changed = true;
                    continue block6;
                }
            }
            try {
                merger.mergeOverlapping(result, similarityFunc, threshold);
                System.err.println("wtf, we didn't fail!");
            }
            catch (RuntimeException ex3) {
                ex3.printStackTrace();
                System.err.println("==============");
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeSetPair
    extends UnorderedPair<ValuedNodeSet>
    implements Comparable<NodeSetPair> {
        Double similarity;

        public NodeSetPair(ValuedNodeSet left, ValuedNodeSet right, double similarity) {
            super(left, right);
            this.similarity = similarity;
        }

        public ValuedNodeSet getOtherThan(ValuedNodeSet item) {
            if (this.getLeft() == item) {
                return (ValuedNodeSet)this.getRight();
            }
            return (ValuedNodeSet)this.getLeft();
        }

        @Override
        public int compareTo(NodeSetPair other) {
            if (this.equals(other) && this.similarity == other.similarity) {
                return 0;
            }
            if (this.similarity < other.similarity) {
                return 1;
            }
            if (this.similarity > other.similarity) {
                return -1;
            }
            return ((ValuedNodeSet)this.getLeft()).compareTo((NodeSet)this.getRight());
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 149 * this.similarity.hashCode();
        }

        public String toString() {
            return "{" + ((ValuedNodeSet)this.getLeft()).toString() + "} - {" + ((ValuedNodeSet)this.getRight()).toString() + "}: " + this.similarity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VerificationMode {
        OFF,
        VERIFY,
        VERIFY_AND_MINIMIZE;

    }
}

