/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.independentsamples;

import java.util.Arrays;
import uk.ac.rhul.cs.stats.StatsUtils;
import uk.ac.rhul.cs.stats.tests.H1;
import uk.ac.rhul.cs.stats.tests.SignificanceTest;
import uk.ac.rhul.cs.utils.ArrayUtils;

public class MannWhitneyTest
implements SignificanceTest {
    private int nA;
    private int nB;
    private double U;
    private double tieCorrection;
    private H1 alternative;

    public MannWhitneyTest(double[] xA, double[] xB) {
        this(xA, xB, H1.NOT_EQUAL, 1.0E-7);
    }

    public MannWhitneyTest(double[] xA, double[] xB, H1 alternative) {
        this(xA, xB, alternative, 1.0E-7);
    }

    public MannWhitneyTest(double[] xA, double[] xB, H1 alternative, double tolerance) {
        int i;
        double uB;
        this.nA = xA.length;
        this.nB = xB.length;
        int n = this.nA + this.nB;
        double[] joined = new double[n];
        System.arraycopy(xA, 0, joined, 0, this.nA);
        System.arraycopy(xB, 0, joined, this.nA, this.nB);
        double[] ranks = ArrayUtils.getRanks(joined, tolerance);
        double uA = uB = (double)(this.nA * this.nB);
        for (i = 0; i < this.nA; ++i) {
            uA -= ranks[i];
        }
        this.U = alternative == H1.NOT_EQUAL ? Math.min(uA, uB -= uA) : (uA += (double)(this.nA * (this.nA + 1) / 2));
        Arrays.sort(ranks);
        if (n < 2) {
            this.tieCorrection = 1.0;
        } else {
            this.tieCorrection = 0.0;
            for (i = 0; i < n - 1; ++i) {
                if (ranks[i] != ranks[i + 1]) continue;
                int nties = 1;
                while (i < n - 1 && ranks[i] == ranks[i + 1]) {
                    ++nties;
                    ++i;
                }
                this.tieCorrection += (double)(nties * (nties * nties - 1));
            }
            this.tieCorrection = 1.0 - this.tieCorrection / (double)n / (double)(n * n - 1);
        }
        this.alternative = alternative;
    }

    public double getCorrectionFactor() {
        return this.tieCorrection;
    }

    public double getSP() {
        int n = this.nA + this.nB;
        double z = this.U - (double)(this.nA * this.nB) / 2.0;
        double sd = Math.sqrt((double)(this.nA * this.nB) / 12.0 * (double)(n + 1) * this.tieCorrection);
        double continuityCorrection = 0.0;
        switch (this.alternative) {
            case NOT_EQUAL: {
                continuityCorrection = Math.signum(z) * 0.5;
                break;
            }
            case LESS_THAN: {
                continuityCorrection = 0.5;
                break;
            }
            case GREATER_THAN: {
                continuityCorrection = -0.5;
            }
        }
        z = (z - continuityCorrection) / sd;
        switch (this.alternative) {
            case NOT_EQUAL: {
                z = Math.abs(z);
                return 2.0 * StatsUtils.getZProbability(-z);
            }
            case LESS_THAN: {
                return 1.0 - StatsUtils.getZProbability(z);
            }
            case GREATER_THAN: {
                return StatsUtils.getZProbability(z);
            }
        }
        return Double.NaN;
    }

    public double getTestStatistic() {
        return this.U;
    }

    public int sizeA() {
        return this.nA;
    }

    public int sizeB() {
        return this.nB;
    }
}

