% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchIsotopes.R
\name{searchIsotopes}
\alias{searchIsotopes}
\title{Target isotopes search}
\usage{
searchIsotopes(
  results,
  MS1,
  label,
  adductsTable = LipidMS::adductsTable,
  rttol = 10,
  ppm = 10
)
}
\arguments{
\item{results}{annotation results for an unlabelled sample. Output of
identification functions (i.e. idPOS$results).}

\item{MS1}{Data frame with at least three columns: m.z, RT, int. Peak list
for the labelled sample. Output of \link{dataProcessing} function
(MS$peaklist).}

\item{label}{isotope employed for the experiment. It can be "13C" or "D".}

\item{adductsTable}{adducts table employed for lipids annotation.}

\item{rttol}{rt window in seconds.}

\item{ppm}{mass error tolerance.}
}
\value{
List with the isotopes for each compound in the results data frame.
}
\description{
This function uses annotation results of an unlabelled sample to search
for labelled compounds in a labelled sample.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
