% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{alpha}
\alias{alpha}
\title{Calculate Cronbach's Alpha from a correlation matrix or dataframe}
\usage{
alpha(cormatrix = NULL, data = NULL)
}
\arguments{
\item{cormatrix}{(real) a square symmetrical matrix with values
ranging from -1 to +1 and '1' in the diagonal}

\item{data}{(real) a dataframe or matrix}
}
\value{
a single value
}
\description{
\code{alpha()} calculate Cronbach's Alpha from a given
correlation matrix or a given dataframe.
}
\examples{

## Sample data frame
df <- data.frame(
  V1  =  c(4, 2, 4, 3, 2, 2, 2, 1),
  V2  =  c(4, 1, 3, 4, 4, 3, 2, 3),
  V3  =  c(4, 1, 3, 5, 4, 1, 4, 2),
  V4  =  c(4, 3, 4, 5, 3, 3, 3, 3)
)

## example correlation matrix
corMat <- matrix(
  c(
    1.00, 0.35, 0.45, 0.70,
    0.35, 1.00, 0.60, 0.55,
    0.45, 0.60, 1.00, 0.65,
    0.70, 0.55, 0.65, 1.00
  ),
  nrow = 4, ncol = 4
)

## apply function examples

alpha(cormatrix = corMat)

alpha(, df)

alpha(corMat, df)

}
