% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{orlando_itemf}
\alias{orlando_itemf}
\title{Orlando's statistic}
\usage{
orlando_itemf(patterns, G, zeta, model)
}
\arguments{
\item{patterns}{list of patterns response (patterns$patterns), the frequency of each pattern (patterns$freq) and the latent traits (patterns$latent_traits).}

\item{G}{number of quadrature points.}

\item{zeta}{matrix of estimations of the parameters of the items (alphas, d's, guessing).}

\item{model}{type of model ( "1PL", 2PL", "3PL" ).}
}
\value{
Orlando's statistic, degrees of freedom and p-value for each item.
}
\description{
Calculate the values of the statistics S_x2 from
Maria Orlando and David Thisen (2000).
}
\references{
Orlando, M. & Thissen, D. (2000). Likelihood-based item fit indices for dichotomous item
response theory models. \emph{Applied Psychological Measurement, 24}, 50-64.
}
\seealso{
\code{\link{z3_itemf}}
}

