% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltrcrrf.R
\name{ltrcrrf}
\alias{ltrcrrf}
\title{Fit a LTRC relative risk forest}
\usage{
ltrcrrf(
  formula,
  data,
  id,
  ntree = 100L,
  mtry = NULL,
  nodesize = max(ceiling(sqrt(nrow(data))), 15),
  bootstrap = c("by.sub", "by.root", "by.node", "by.user", "none"),
  samptype = c("swor", "swr"),
  sampfrac = 0.632,
  samp = NULL,
  na.action = "na.omit",
  stepFactor = 2,
  trace = TRUE,
  nodedepth = NULL,
  nsplit = 10L,
  ntime
)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}}
object, with form


\code{Surv(tleft, tright, event)}.}

\item{data}{a data frame containing \code{n} rows of
left-truncated right-censored observations.
For time-varying data, this should be
a data frame containing pseudo-subject observations based on the Andersen-Gill
reformulation.}

\item{id}{variable name of subject identifiers. If this is present, it will be
searched for in the \code{data} data frame. Each group of rows in \code{data}
with the same subject \code{id} represents the covariate path through time of
a single subject. If not specified, the algorithm then assumes \code{data}
contains left-truncated and right-censored survival data with time-invariant
covariates.}

\item{ntree}{an integer, the number of the trees to grow for the forest.
\code{ntree = 100L} is set by default.}

\item{mtry}{number of input variables randomly sampled as candidates at each node for
random forest like algorithms. The default \code{mtry} is tuned by
\code{\link{tune.ltrcrrf}}.}

\item{nodesize}{an integer, forest average terminal node size.}

\item{bootstrap}{bootstrap protocol.
(1) If \code{id} is present,
the choices are: \code{"by.sub"} (by default) which bootstraps subjects,
\code{"by.root"} which bootstraps pseudo-subjects.
Both can be with or without replacement (by default sampling is without
replacement; see the option \code{samptype} below).
(2) If \code{id} is not specified, the default is \code{"by.root"} which
bootstraps the \code{data} by sampling with or without replacement;
if \code{"by.node"} is choosen, \code{data} is bootstrapped with replacement
at each node while growing the tree.
Regardless of the presence of \code{id}, if \code{"none"} is chosen,
\code{data} is not bootstrapped at all, and is used in
every individual tree. If \code{"by.user"} is choosen,
the bootstrap specified by \code{samp} is used.}

\item{samptype}{choices are \code{swor} (sampling without replacement) and
\code{swr} (sampling with replacement). The default action here is sampling
without replacement.}

\item{sampfrac}{a fraction, determining the proportion of subjects to draw
without replacement when \code{samptype = "swor"}. The default value is \code{0.632}.
To be more specific, if \code{id} is present, \code{0.632 * N} of subjects with their
pseudo-subject observations are drawn without replacement (\code{N} denotes the
number of subjects); otherwise, \code{0.632 * n} is the requested size
of the sample.}

\item{samp}{Bootstrap specification when \code{bootstype = "by.user"}.
Array of dim \code{n x ntree} specifying how many times each record appears
in each bootstrap sample.}

\item{na.action}{action taken if the data contains \code{NA}’s. The default
\code{"na.omit"} removes the entire record if any of its entries is
\code{NA} (for x-variables this applies only to those specifically listed
in \code{formula}). See function \code{\link[randomForestSRC]{rfsrc}} for
other available options.}

\item{stepFactor}{at each iteration, \code{mtry} is inflated (or deflated)
by this value, used when \code{mtry} is not specified (see \code{\link{tune.ltrcrrf}}).
The default value is \code{2}.}

\item{trace}{whether to print the progress of the search of the optimal value
of \code{mtry} if \code{mtry} is not specified (see \code{\link{tune.ltrcrrf}}).
\code{trace = TRUE} is set by default.}

\item{nodedepth}{maximum depth to which a tree should be grown. The default behaviour
is that this parameter is ignored.}

\item{nsplit}{an non-negative integer value for number of random splits to consider
for each candidate splitting variable. This significantly increases speed.
When zero or \code{NULL}, the algorithm uses much slower deterministic splitting where
all possible splits are considered. \code{nsplit = 10L} by default.}

\item{ntime}{an integer value used for survival to constrain ensemble calculations
to a grid of \code{ntime} time points. Alternatively if a vector of values
of length greater than one is supplied, it is assumed these are the time points
to be used to constrain the calculations (note that the constrained time points
used will be the observed event times closest to the user supplied time points).
If no value is specified, the default action is to use all observed event times.
Further demails can be found in \code{\link[randomForestSRC]{rfsrc}}.}
}
\value{
An object belongs to the class \code{ltrcrrf}.
}
\description{
An implementation of the random forest algorithms utilizing LTRC \code{rpart}
trees \code{\link[LTRCtrees]{LTRCART}} as base learners for left-truncated right-censored
survival data with time-invariant covariates. It also allows for (left-truncated)
right-censored survival data with time-varying covariates.
}
\details{
This function extends the relative risk forest algorithm (Ishwaran et al. 2004) 
to fit left-truncated and right-censored data,
which allows for time-varying covariates. The algorithm is built based on employing
the fast C code from \code{\link[randomForestSRC]{rfsrc}}.
}
\examples{
#### Example with time-varying data pbcsample
library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
# Built a LTRCRRF forest (based on bootstrapping subjects without replacement)
# on the time-varying data by specifying id:
LTRCRRFobj = ltrcrrf(formula = Formula, data = pbcsample, id = ID, stepFactor = 3,
                     ntree = 10L)


}
\references{
Andersen, P. and Gill, R. (1982). Cox’s regression model for counting
processes, a large sample study. \emph{Annals of Statistics}, \strong{10}:1100-1120.

H. Ishwaran, E. H. Blackstone, C. Pothier, and M. S. Lauer. (2004).
Relative risk forests for exercise heart rate recovery as a predictor of mortality.
\emph{Journal of the American StatisticalAssociation}, \strong{99}(1):591–600.

Fu, W. and Simonoff, J.S. (2016). Survival trees for left-truncated and 
right-censored data, with application to time-varying covariate data. 
\emph{Biostatistics}, \strong{18}(2):352–369.
}
\seealso{
\code{\link{predictProb}} for prediction and \code{\link{tune.ltrcrrf}}
for \code{mtry} tuning.
}
