% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic-do.R
\name{mosaic_cull_for_do}
\alias{mosaic_cull_for_do}
\title{Cull objects used with do()}
\usage{
mosaic_cull_for_do(object, ...)
}
\arguments{
\item{object}{an object to be culled}

\item{...}{additional arguments (currently ignored)}
}
\description{
The \code{\link[=do]{do()}} function facilitates easy replication for
randomization tests and bootstrapping (among other things).  Part of what
makes this particularly useful is the ability to cull from the objects
produced those elements that are useful for subsequent analysis.
\code{cull_for_do} does this culling.  It is generic, and users
can add new methods to either change behavior or to handle additional
classes of objects.
}
\details{
When \code{do(n) * expression} is evaluated, \code{expression}
is evaluated \code{n} times to produce a list of \code{n} result objects.
\code{cull_for_do} is then applied to each element of this list to
extract from it the information that should be stored.  For example,
when applied to a object of class \code{"lm"},
the default \code{cull_for_do} extracts the coefficients, coefficient
of determinism, an the estimate for the variance, etc.
}
\examples{
Clock_auction |> model_train(price ~ resample(bidders)) |>
  R2() |> trials(times=10)
}
