###############################################
# Null True
###############################################
for (alt in c("two.sided", "greater", "less")) {
  set.seed(1)
  x <- rnorm(200, 0, 1)
  test <- gaussian_mu_one_sample(x, 0, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with t test
  test_02 <- stats::t.test(x, alternative = alt)
  test_that("Check contents", {
    expect_true(test$p.value > .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  # .0499 instead of .05 b/c of floating point error associated with convergence.
  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  test_that("Check CI", {
    expect_true(ifelse(is.finite(CI1), gaussian_mu_one_sample(x, CI1, alt)$p.value, .05) >= .0499)
    expect_true(ifelse(is.finite(CI2), gaussian_mu_one_sample(x, CI2, alt)$p.value, .05) >= .0499)
  })
  rm(CI1, CI2)
}

###############################################
# Null False
###############################################
for (alt in c("two.sided", "greater")) {
  set.seed(1)
  x <- rnorm(200, 3, 1)
  test <- gaussian_mu_one_sample(x, 0, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with t test
  test_02 <- stats::t.test(x, alternative = alt)
  test_that("Check contents", {
    expect_true(test$p.value <= .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  pval <- pmin(
    ifelse(is.finite(CI1), gaussian_mu_one_sample(x, CI1, alt)$p.value, .05),
    ifelse(is.finite(CI2), gaussian_mu_one_sample(x, CI2, alt)$p.value, .05)
  )
  test_that("Check CI", {
    expect_true(pval <= .0500001)
  })
  rm(CI1, CI2, pval)
}

for (alt in c("two.sided", "less")) {
  set.seed(1)
  x <- rnorm(200, -3, 1)
  test <- gaussian_mu_one_sample(x, 0, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with t test
  test_02 <- stats::t.test(x, alternative = alt)
  test_that("Check contents", {
    expect_true(test$p.value <= .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  pval <- pmin(
    ifelse(is.finite(CI1), gaussian_mu_one_sample(x, CI1, alt)$p.value, .05),
    ifelse(is.finite(CI2), gaussian_mu_one_sample(x, CI2, alt)$p.value, .05)
  )
  test_that("Check CI", {
    expect_true(pval <= .0500001)
  })
  rm(CI1, CI2, pval)
}

###############################################
# Input checking
###############################################
test_that("x input checking works", {
  expect_error(gaussian_mu_one_sample(c()), "Argument x should have at least 50 data points.")
  expect_error(gaussian_mu_one_sample(rep("foo", 50)), "Argument x should be numeric.")
})

set.seed(1)
x <- rnorm(50)
test_that("mu input checking works", {
  expect_error(gaussian_mu_one_sample(x, c(1, 2)), "The tested parameter should have length one.")
  expect_error(gaussian_mu_one_sample(x, "foo"), "The tested parameter should be numeric.")
})

test_that("alternative input checking works", {
  expect_error(gaussian_mu_one_sample(x, 0, c("two.sided", "less")), "Argument alternative should have length one.")
  expect_error(gaussian_mu_one_sample(x, 0, 1), "Argument alternative should be a character.")
  expect_error(gaussian_mu_one_sample(x, 0, "lesss"), "Argument alternative should be 'two.sided', 'less', or 'greater.")
})

test_that("conf.level input checking works", {
  expect_error(gaussian_mu_one_sample(x, 1, "less", c(.50, .75)), "conf.level should have length one.")
  expect_error(gaussian_mu_one_sample(x, 1, "less", "foo"), "conf.level should be numeric.")
  expect_error(gaussian_mu_one_sample(x, 1, "less", 0), "conf.level should between zero and one.")
  expect_error(gaussian_mu_one_sample(x, 1, "less", 1), "conf.level should between zero and one.")
})

###############################################
# Null True
###############################################
for (alt in c("two.sided", "greater", "less")) {
  set.seed(1)
  x <- rnorm(1000, 0, 3)
  test <- gaussian_variance_one_sample(x, 9, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with chi square test for variance
  test_02 <- EnvStats::varTest(x, alternative = alt, sigma.squared = 9)
  test_that("Check contents", {
    expect_true(test$p.value > .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  # .0499 instead of .05 b/c of floating point error associated with convergence.
  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  test_that("Check CI", {
    expect_true(ifelse(is.finite(CI1), gaussian_variance_one_sample(x, CI1, alt)$p.value, .05) >= .0499)
    expect_true(ifelse(is.finite(CI2), gaussian_variance_one_sample(x, CI2, alt)$p.value, .05) >= .0499)
  })
  rm(CI1, CI2)
}

###############################################
# Null False
###############################################
for (alt in c("two.sided", "greater")) {
  set.seed(2)
  x <- rnorm(100, 0, 3)
  test <- gaussian_variance_one_sample(x, 8, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with chi square test for variance
  test_02 <- EnvStats::varTest(x, alternative = alt, sigma.squared = 8)
  test_that("Check contents", {
    expect_true(test$p.value <= .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  pval <- pmin(
    ifelse(is.finite(CI1), gaussian_variance_one_sample(x, CI1, alt)$p.value, .05),
    ifelse(is.finite(CI2), gaussian_variance_one_sample(x, CI2, alt)$p.value, .05)
  )
  test_that("Check CI", {
    expect_true(pval <= .0500001)
  })
  rm(CI1, CI2, pval)
}

for (alt in c("two.sided", "less")) {
  set.seed(1)
  x <- rnorm(200, 0, 3)
  test <- gaussian_variance_one_sample(x, 10, alt)

  test_that("Check structure.", {
    expect_true(all(class(test) == c("one_sample_case_one", "lrtest")))
    expect_true(length(test) == 5)
    expect_true(all(names(test) == c("statistic", "p.value", "conf.int", "conf.level", "alternative")))
  })

  # Compare with chi square test for variance
  test_02 <- EnvStats::varTest(x, alternative = alt, sigma.squared = 10)
  test_that("Check contents", {
    expect_true(test$p.value <= .05)
    expect_true(abs(test$p.value - test_02$p.value) < .01)
  })

  CI1 <- test$conf.int[1] + .Machine$double.eps # Avoid boundary
  CI2 <- test$conf.int[2] - .Machine$double.eps
  pval <- pmin(
    ifelse(is.finite(CI1), gaussian_variance_one_sample(x, CI1, alt)$p.value, .05),
    ifelse(is.finite(CI2), gaussian_variance_one_sample(x, CI2, alt)$p.value, .05)
  )
  test_that("Check CI", {
    expect_true(pval <= .0500001)
  })
  rm(CI1, CI2, pval)
}

###############################################
# Input checking
###############################################
test_that("x input checking works", {
  expect_error(gaussian_variance_one_sample(c()), "Argument x should have at least 50 data points.")
  expect_error(gaussian_variance_one_sample(rep("foo", 50)), "Argument x should be numeric.")
})

set.seed(1)
x <- rnorm(50)
test_that("variance input checking works", {
  expect_error(gaussian_variance_one_sample(x, c(1, 2)), "The tested parameter should have length one.")
  expect_error(gaussian_variance_one_sample(x, "foo"), "The tested parameter should be numeric.")
  expect_error(gaussian_variance_one_sample(x, 0), "The tested parameter should be above 0.")
})

test_that("alternative input checking works", {
  expect_error(gaussian_variance_one_sample(x, 1, c("two.sided", "less")), "Argument alternative should have length one.")
  expect_error(gaussian_variance_one_sample(x, 1, 1), "Argument alternative should be a character.")
  expect_error(gaussian_variance_one_sample(x, 1, "lesss"), "Argument alternative should be 'two.sided', 'less', or 'greater.")
})

test_that("alternative input checking works", {
  expect_error(gaussian_variance_one_sample(x, 1, "less", c(.50, .75)), "conf.level should have length one.")
  expect_error(gaussian_variance_one_sample(x, 1, "less", "foo"), "conf.level should be numeric.")
  expect_error(gaussian_variance_one_sample(x, 1, "less", 0), "conf.level should between zero and one.")
  expect_error(gaussian_variance_one_sample(x, 1, "less", 1), "conf.level should between zero and one.")
})

###############################################
# Null True
###############################################
set.seed(1)
x <- rnorm(150, 1, 1)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
test <- gaussian_mu_one_way(x, fctr, .95)

test_that("Check structure.", {
  expect_true(all(class(test) == c("one_way_case_one", "lrtest")))
  expect_true(length(test) == 6)
  expect_true(all(names(test) == c("statistic", "p.value", "conf.ints", "overall.conf", "individ.conf", "alternative")))
})

dat <- data.frame(fctr = fctr, x = x)
model_00 <- lm(x ~ 1, data = dat)
model_01 <- lm(x ~ fctr, data = dat)

test_02 <- lmtest::lrtest(model_00, model_01)
test_that("Check contents", {
  expect_true(test$p.value > .05)
  expect_equal(test$p.value, test_02[["Pr(>Chisq)"]][2])
})

# make sure CIs match
CI1 <- unname(test$conf.ints[[1]])
CI2 <- gaussian_mu_one_sample(x[which(fctr == 1)], 0, test$alternative, test$individ.conf)$conf.int
test_that("Check CI", {
  expect_equal(CI1, CI2)
})
rm(CI1, CI2, dat, model_00, model_01)

###############################################
# Null False
###############################################

set.seed(1)
x <- c(rnorm(50, 1.5, 1), rnorm(50, 2, 1), rnorm(50, 2.25, 1))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
test <- gaussian_mu_one_way(x, fctr, .95)

test_that("Check structure.", {
  expect_true(all(class(test) == c("one_way_case_one", "lrtest")))
  expect_true(length(test) == 6)
  expect_true(all(names(test) == c("statistic", "p.value", "conf.ints", "overall.conf", "individ.conf", "alternative")))
})

dat <- data.frame(fctr = fctr, x = x)
model_00 <- lm(x ~ 1, data = dat)
model_01 <- lm(x ~ fctr, data = dat)

test_02 <- lmtest::lrtest(model_00, model_01)
test_that("Check contents", {
  expect_true(test$p.value < .05)
  expect_equal(test$p.value, test_02[["Pr(>Chisq)"]][2])
})

# make sure CIs match
CI1 <- unname(test$conf.ints[[1]])
CI2 <- gaussian_mu_one_sample(x[which(fctr == 1)], 0, test$alternative, test$individ.conf)$conf.int
test_that("Check CI", {
  expect_equal(CI1, CI2)
})
rm(CI1, CI2, dat, model_00, model_01)

###############################################
# Input checking
###############################################
test_that("x input checking works", {
  expect_error(gaussian_mu_one_way(c()), "Argument x should have at least 50 data points.")
  expect_error(gaussian_mu_one_way(rep("foo", 50)), "Argument x should be numeric.")
})

set.seed(1)
x <- rnorm(100)
fctr1 <- factor(rep(1, 100), levels = c("1", "2", "3"))
fctr2 <- factor(c(rep(1, 60), rep(2, 40)), levels = c("1", "2", "3"))
test_that("fctr input checking works", {
  expect_error(gaussian_mu_one_way(x, "foo"), "Argument fctr should have same length as x.")
  expect_error(gaussian_mu_one_way(x, rep("foo", 100)), "Argument fctr should be a factor.")
  expect_error(gaussian_mu_one_way(x, factor(rep("foo", 100))), "Argument fctr should have at least two unique values.")
  expect_error(gaussian_mu_one_way(x, fctr1), "Argument fctr should have at least two unique values.")
  expect_error(gaussian_mu_one_way(x, fctr2), "Each groups needs to contain at least 50 points for CIs to be accurate.")
})
rm(fctr1, fctr2)

fctr <- c(rep(1, 50), rep(2, 50))
fctr <- factor(fctr, levels = c("1", "2"))
test_that("conf.level input checking works", {
  expect_error(gaussian_mu_one_way(x, fctr, c(.50, .75)), "conf.level should have length one.")
  expect_error(gaussian_mu_one_way(x, fctr, "foo"), "conf.level should be numeric.")
  expect_error(gaussian_mu_one_way(x, fctr, 0), "conf.level should between zero and one.")
  expect_error(gaussian_mu_one_way(x, fctr, 1), "conf.level should between zero and one.")
})

###############################################
# Null True
###############################################
set.seed(1)
x <- rnorm(150, 1, 1)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
test <- gaussian_variance_one_way(x, fctr, .95)

test_that("Check structure.", {
  expect_true(all(class(test) == c("one_way_case_one", "lrtest")))
  expect_true(length(test) == 6)
  expect_true(all(names(test) == c("statistic", "p.value", "conf.ints", "overall.conf", "individ.conf", "alternative")))
})

# Compare with other test
test_02 <- stats::bartlett.test(x, fctr)
test_that("Check contents", {
  expect_true(test$p.value > .05)
  expect_true(abs(test$p.value - test_02$p.value) < .02)
})

# make sure CIs match
CI1 <- unname(test$conf.ints[[1]])
CI2 <- gaussian_variance_one_sample(x[which(fctr == 1)], 5, test$alternative, test$individ.conf)$conf.int
test_that("Check CI", {
  expect_equal(CI1, CI2)
})
rm(CI1, CI2)

###############################################
# Null False
###############################################

set.seed(1)
x <- c(rnorm(50, 1, 1), rnorm(50, 1, 1.2), rnorm(50, 1, 1.4))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
test <- gaussian_variance_one_way(x, fctr, .95)

test_that("Check structure.", {
  expect_true(all(class(test) == c("one_way_case_one", "lrtest")))
  expect_true(length(test) == 6)
  expect_true(all(names(test) == c("statistic", "p.value", "conf.ints", "overall.conf", "individ.conf", "alternative")))
})

test_02 <- stats::bartlett.test(x, fctr)
test_that("Check contents", {
  expect_true(test$p.value < .05)
  expect_true(abs(test$p.value - test_02$p.value) < .02)
})

# make sure CIs match
CI1 <- unname(test$conf.ints[[1]])
CI2 <- gaussian_variance_one_sample(x[which(fctr == 1)], 5, test$alternative, test$individ.conf)$conf.int
test_that("Check CI", {
  expect_equal(CI1, CI2)
})
rm(CI1, CI2)

###############################################
# Input checking
###############################################
test_that("x input checking works", {
  expect_error(gaussian_variance_one_way(c()), "Argument x should have at least 50 data points.")
  expect_error(gaussian_variance_one_way(rep("foo", 50)), "Argument x should be numeric.")
})

set.seed(1)
x <- rnorm(100)
fctr1 <- factor(rep(1, 100), levels = c("1", "2", "3"))
fctr2 <- factor(c(rep(1, 60), rep(2, 40)), levels = c("1", "2", "3"))
test_that("fctr input checking works", {
  expect_error(gaussian_variance_one_way(x, "foo"), "Argument fctr should have same length as x.")
  expect_error(gaussian_variance_one_way(x, rep("foo", 100)), "Argument fctr should be a factor.")
  expect_error(gaussian_variance_one_way(x, factor(rep("foo", 100))), "Argument fctr should have at least two unique values.")
  expect_error(gaussian_variance_one_way(x, fctr1), "Argument fctr should have at least two unique values.")
  expect_error(gaussian_variance_one_way(x, fctr2), "Each groups needs to contain at least 50 points for CIs to be accurate.")
})
rm(fctr1, fctr2)

fctr <- c(rep(1, 50), rep(2, 50))
fctr <- factor(fctr, levels = c("1", "2"))
test_that("conf.level input checking works", {
  expect_error(gaussian_variance_one_way(x, fctr, c(.50, .75)), "conf.level should have length one.")
  expect_error(gaussian_variance_one_way(x, fctr, "foo"), "conf.level should be numeric.")
  expect_error(gaussian_variance_one_way(x, fctr, 0), "conf.level should between zero and one.")
  expect_error(gaussian_variance_one_way(x, fctr, 1), "conf.level should between zero and one.")
})
