% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{icp}
\alias{icp}
\title{icp}
\usage{
icp(
  X,
  Y,
  weights = NULL,
  iterations = 100,
  subsample = NULL,
  scale = FALSE,
  tol = 0.001
)
}
\arguments{
\item{X}{reference point set, a N x D matrix}

\item{Y}{point set to transform, a M x D matrix,}

\item{weights}{vector of length nrow(Y) containing weights for each point in Y. Not implemented.}

\item{iterations}{number of iterations to perform (default: 100)}

\item{subsample}{if set, use this randomly selected fraction of the points}

\item{scale}{logical (default: FALSE), whether to use scaling.}

\item{tol}{tolerance for determining convergence}
}
\value{
a list of
\itemize{
   \item Y: transformed point set, a M x D matrix,
   \item R: rotation matrix, 
   \item t: translation vector, 
   \item s: scaling factor, 
   \item iter: number of iterations performed,
   \item conv: boolean, whether the algorithm has converged.
}
}
\description{
Rigid registration of two point sets using the iterative closest point algorithm.
}
\examples{
data.file1 <- system.file("test_data", "parasaurolophusA.txt", package = "LOMAR",
 mustWork = TRUE)
PS1 <- read.csv(data.file1, sep = '\t', header = FALSE)
data.file2 <- system.file("test_data", "parasaurolophusB.txt", package = "LOMAR",
 mustWork = TRUE)
PS2 <- read.csv(data.file2, sep = '\t', header = FALSE)
transformation <- icp(PS1, PS2, iterations = 10, tol = 1e-3)
\dontrun{
# Visualize registration outcome
library(rgl)
plot3d(PS1, col = "blue")
points3d(PS2, col = "green")
points3d(transformation[['Y']], col = "magenta")
}
}
