% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDA.R
\name{get_persistence_diagrams}
\alias{get_persistence_diagrams}
\title{get_persistence_diagrams}
\usage{
get_persistence_diagrams(
  point.sets = NULL,
  maxdimension = NULL,
  maxscale = NULL,
  use.dtm = FALSE,
  m0 = NULL,
  grid.by = NULL,
  ncpu = 1
)
}
\arguments{
\item{point.sets}{list of point sets, each as a data frame with columns x,y,z}

\item{maxdimension}{maximum dimension of the homological features to be computed}

\item{maxscale}{limit of the Vietoris-Rips filtration}

\item{use.dtm}{logical (default: FALSE), whether to use the distance to measure function}

\item{m0}{parameter for the dtm function}

\item{grid.by}{vector of space between points of the grid for the dtm function along each dimension}

\item{ncpu}{number of parallel threads to use for computation}
}
\value{
a list of persistence diagrams as n x 3 matrices. Each row is a topological feature
 and the columns are dimension, birth and death of the feature.
}
\description{
Compute persistence diagrams for a list of point sets.
By default, compute persistent homology from the Vietoris-Rips filtration.
If use.dtm is TRUE, compute instead the persistent homology of the sublevel
set of the distance to measure evaluated over a grid.
}
\examples{
PS <- list(data.frame(x = c(2.4,-6.9,4.6,-0.7,-3.3,-4.9,-3.5,-3.5,4.2,-7),
                      y = c(5.7,1.9,4.8,3.4,-3,-2.1,7.2,1.8,6.1,-1.6),
                      z = c(2.7,-0.1,-0.7,-0.6,0.4,-1.5,-0.6,-0.9,2.2,0.7)),
           data.frame(x = c(0,0,3.1,-5.6,-5,-7.4,-0.7,-7.7,-6.7,4,4.2,0.2,5.8,3.9,3.9),
                      y = c(6.3,-6.1,-3.5,4.6,-4.1,0.3,8.8,-2.3,2.9,3.7,-1.4,-3.9,5.5,-1.2,-6.7),
                      z = c(-1.5,1.7,-0.4,-1.4,1.8,1.7,-0.9,-1.8,-0.5,1.7,1.3,0.5,-1.4,1.6,-0.1)))
Diags <- get_persistence_diagrams(point.sets = PS, maxdimension = 1, maxscale = 5, ncpu = 1)
}
