% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHANES.R
\docType{data}
\name{NHANES}
\alias{NHANES}
\title{National Health and Nutrition Examination Survey (NHANES) Data}
\format{A data frame with 186 rows and 13 variables:
\describe{
  \item{SBP}{systolic blood pressure}
  \item{gender}{male or female}
  \item{age}{in years}
  \item{race}{race / Hispanic origin (5 categories)}
  \item{WC}{waist circumference in cm}
  \item{alc}{alcohol consumption (binary: <1 drink per week vs. >= 1 drink per week)}
  \item{educ}{educational level (binary: low vs. high)}
  \item{creat}{creatinine concentration in mg/dL}
  \item{albu}{albumin concentration in g/dL}
  \item{uricacid}{uric acid concentration in mg/dL}
  \item{bili}{bilirubin concentration in mg/dL}
  \item{occup}{occupational status (3 categories)}
  \item{smoke}{smoking status (3 ordered categories)}
  }}
\source{
National Center for Health Statistics (NCHS) (2011 - 2012).
        National Health and Nutrition Examination Survey Data.
        URL \href{https://www.cdc.gov/nchs/nhanes/}{https://www.cdc.gov/nchs/nhanes/}.
}
\usage{
data(NHANES)
}
\description{
This data is a small subset of the data collected within the 2011-2012 wave
of the NHANES study, a study designed to assess the health and nutritional
status of adults and children in the United States, conduced by the
\href{https://www.cdc.gov/nchs/}{National Center for Health Statistics}.
}
\section{Note}{

The subset provided here was selected and re-coded to facilitate
demonstration of the functionality of the JointAI package,
and no clinical conclusions should be derived from it.
}

\examples{
summary(NHANES)
}
\keyword{datasets}
