/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.FileLocator;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.omegahat.Environment.IO.ArchiveEntry;
import org.omegahat.Environment.Tools.ClassList.ObjectList;
import org.omegahat.Environment.Tools.FileLocator.DynamicFileFilter;
import org.omegahat.Environment.Tools.FileLocator.FileLocatorInt;
import org.omegahat.Environment.Utils.StringUtils;

public class FileLocator
extends Vector
implements FileLocatorInt {
    public DynamicFileFilter filter = null;

    public FileLocator() {
    }

    public FileLocator(String string) {
        this.searchPath(string);
    }

    public FileLocator(Vector vector2) {
        this.searchPath(vector2);
    }

    public FileLocator(String[] stringArray) {
        this.searchPath(stringArray);
    }

    public boolean add(Object object) {
        boolean bl = true;
        if (object instanceof String) {
            bl = this.add((String)object);
        } else if (object instanceof File) {
            this.addElement((File)object);
        } else if (object instanceof ZipFile) {
            this.addElement(object);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean add(String string) {
        String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : (string.equals("") ? "." : string);
        super.addElement(this.createElement(string2));
        return true;
    }

    public boolean add(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        Vector vector2 = this.searchPath();
        if (vector2 == null) {
            vector2 = this.searchPath(new Vector(stringArray.length));
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addElement(stringArray[n]);
            ++n;
        }
        return true;
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        Enumeration enumeration = this.searchPath().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof ObjectList) {
                stringBuffer.append(((ObjectList)e).file());
            } else {
                stringBuffer.append(e);
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public Object createElement(String string) {
        Object object;
        block2: {
            object = string;
            try {
                new ZipFile(string);
                object = new ObjectList(new File(string));
            }
            catch (IOException iOException) {
                File file = new File(string);
                if (!file.canRead()) break block2;
                object = file;
            }
        }
        return object;
    }

    public DynamicFileFilter filter() {
        if (this.filter == null) {
            this.filter = new DynamicFileFilter();
        }
        return this.filter;
    }

    public DynamicFileFilter filter(FilenameFilter filenameFilter) {
        this.filter = (DynamicFileFilter)filenameFilter;
        return this.filter();
    }

    public Object find(File file) {
        return this.find(file, false);
    }

    public Object find(File file, boolean bl) {
        Object object = null;
        if (file.canRead()) {
            return file;
        }
        Enumeration enumeration = this.searchPath().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof File) {
                object = this.findIn((File)e, file);
            } else if (e instanceof String) {
                object = this.findIn(new File((String)e), file);
            } else if (e instanceof ZipFile) {
                object = this.findIn((ZipFile)e, file);
            } else if (e instanceof ObjectList) {
                object = ((ObjectList)e).find(file.toString());
                if (object instanceof ZipEntry) {
                    try {
                        ZipFile zipFile = new ZipFile(((ObjectList)e).file());
                        object = zipFile.getInputStream((ZipEntry)object);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                System.out.println("Neither a file or string in search path " + e);
            }
            if (object == null) continue;
            if (bl) {
                return e;
            }
            return object;
        }
        return object;
    }

    public Object find(String string) {
        if (string == null) {
            return null;
        }
        return this.find(new File(string));
    }

    public Object findIn(File file, File file2) {
        Object object = null;
        File file3 = null;
        try {
            if (this.isArchive(file)) {
                ZipFile zipFile = new ZipFile(file);
                String string = file2.toString();
                ZipEntry zipEntry = zipFile.getEntry(string);
                if (zipEntry == null) {
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        zipEntry = enumeration.nextElement();
                        if (!this.matches(zipEntry, file2)) continue;
                        object = new ArchiveEntry(file, zipEntry.getName());
                        break;
                    }
                }
                zipFile.close();
            } else {
                this.filter().target(file2);
                String[] stringArray = file.list(this.filter());
                if (stringArray != null && stringArray.length > 0) {
                    file3 = new File(String.valueOf(String.valueOf(file)) + "/" + stringArray[0]);
                    object = file3;
                }
            }
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public Object findIn(ZipFile zipFile, File file) {
        InputStream inputStream;
        block2: {
            ZipEntry zipEntry = zipFile.getEntry(file.toString());
            inputStream = null;
            if (zipEntry == null) break block2;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                System.err.println("Problem reading entry " + file + " in zip file " + zipFile.getName());
            }
        }
        return inputStream;
    }

    public boolean isArchive(File file) {
        return file.toString().endsWith(".zip") || file.toString().endsWith(".jar");
    }

    public boolean matches(ZipEntry zipEntry, File file) {
        return this.matches(zipEntry, file.toString());
    }

    public boolean matches(ZipEntry zipEntry, String string) {
        return zipEntry.getName().endsWith(string);
    }

    public Vector searchPath() {
        return this;
    }

    public Vector searchPath(String string) {
        String[] stringArray = null;
        stringArray = string.indexOf(44) > -1 ? StringUtils.stringList(string) : new String[]{string};
        return this.searchPath(stringArray);
    }

    public Vector searchPath(Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
        return this.searchPath();
    }

    public Vector searchPath(String[] stringArray) {
        this.add(stringArray);
        return this.searchPath();
    }

    public Object where(File file) {
        return this.find(file, true);
    }

    public Object where(String string) {
        return this.find(new File(string), true);
    }
}

