/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import j4r.net.SocketWrapper;
import j4r.net.TCPSocketWrapper;
import j4r.net.server.AbstractServer;
import j4r.util.J4RTranslator;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.InvalidParameterException;

public class BasicClient
implements Closeable {
    private SocketWrapper socketWrapper;
    private boolean open;
    private final int timeout;
    private boolean bypassTimeout;

    protected BasicClient(InetSocketAddress socketAddress, int timeoutSeconds) throws BasicClientException {
        this(socketAddress, timeoutSeconds, true);
    }

    protected BasicClient(InetSocketAddress socketAddress, int timeoutSeconds, boolean isAJavaApplication) throws BasicClientException {
        Object replyFromServer;
        if (timeoutSeconds < 0) {
            throw new InvalidParameterException("The timeout delay must be equal to or greater than 0!");
        }
        this.timeout = timeoutSeconds;
        this.bypassTimeout = false;
        try {
            Socket socket = new Socket();
            socket.connect(socketAddress, 5000);
            this.socketWrapper = new TCPSocketWrapper(socket, isAJavaApplication);
        }
        catch (Exception e) {
            this.close();
            throw new BasicClientException(ExceptionType.ConnectionFailed);
        }
        if (isAJavaApplication) {
            replyFromServer = (AbstractServer.ServerReply)((Object)this.readObjectFromServer());
            if (replyFromServer == AbstractServer.ServerReply.CallAccepted) {
                this.open = true;
            } else if (replyFromServer == AbstractServer.ServerReply.IAmBusyCallBackLater) {
                this.open = false;
                this.close();
                throw new BasicClientException(ExceptionType.ConnectionRejected);
            }
        } else {
            replyFromServer = (String)this.readObjectFromServer();
            if (((String)replyFromServer).equals(AbstractServer.ServerReply.CallAccepted.name())) {
                this.open = true;
            } else if (((String)replyFromServer).equals(AbstractServer.ServerReply.IAmBusyCallBackLater.name())) {
                this.open = false;
                this.close();
                throw new BasicClientException(ExceptionType.ConnectionRejected);
            }
        }
    }

    protected Object readObjectFromServer() throws BasicClientException {
        try {
            if (this.bypassTimeout) {
                return this.socketWrapper.readObject();
            }
            return this.socketWrapper.readObject(this.timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            throw this.handleException(e);
        }
    }

    private BasicClientException handleException(Exception e) {
        if (e instanceof SocketTimeoutException) {
            return new BasicClientException(ExceptionType.ConnectionTooLong);
        }
        return new BasicClientException(ExceptionType.UnknownErrorWhileConnected);
    }

    protected Object processRequest(Object obj) throws BasicClientException {
        if (this.open) {
            try {
                this.socketWrapper.writeObject(obj);
            }
            catch (IOException e) {
                this.close();
                e.printStackTrace();
            }
            return this.readObjectFromServer();
        }
        throw new BasicClientException(ExceptionType.ConnectionFailed);
    }

    @Override
    public void close() {
        try {
            try {
                if (this.socketWrapper != null & this.open) {
                    this.socketWrapper.writeObject((Object)ClientRequest.closeConnection);
                }
            }
            catch (IOException iOException) {
                try {
                    if (this.socketWrapper != null) {
                        this.socketWrapper.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                if (this.socketWrapper != null) {
                    this.socketWrapper.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void setBypassTimeout(boolean bypass) {
        this.bypassTimeout = bypass;
    }

    public static class BasicClientException
    extends Exception {
        private BasicClientException(ExceptionType exceptionType) {
            super(exceptionType.toString());
        }
    }

    public static enum ClientRequest {
        closeConnection;

    }

    public static enum ExceptionType implements J4RTranslator.TextableEnum
    {
        ConnectionFailed("The client failed to connect to the server.", "La connexion au serveur n'a pas pu \u00eatre \u00e9tablie."),
        ConnectionRejected("The server is busy and cannot process the requests.", "Le serveur est actuellement occup\u00e9 et ne peut r\u00e9pondre aux requ\u00eates."),
        ConnectionTooLong("The reply from the server has exceeded the allowed time.", "La r\u00e9ponse du serveur a ex\u00e9c\u00e9d\u00e9 le temps d'attente."),
        UnknownErrorWhileConnected("An exception occurred while processing the request.", "Une exception est survenue dans l'ex\u00e9cution de la requ\u00eate.");


        private ExceptionType(String englishText, String frenchText) {
            this.setText(englishText, frenchText);
        }

        @Override
        public void setText(String englishText, String frenchText) {
            J4RTranslator.setString(this, englishText, frenchText);
        }

        public String toString() {
            return J4RTranslator.getString(this);
        }
    }
}

