/*
 * Decompiled with CFR 0.152.
 */
package j4r.lang.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtility {
    public static final Set<Class<?>> PrimitiveWrappers = new HashSet();
    public static final Map<String, Class<?>> PrimitiveTypeMap;
    public static final Map<Class<?>, Class<?>> JavaWrapperToPrimitiveMap;
    public static final Map<Class<?>, Class<?>> PrimitiveToJavaWrapperMap;

    static {
        PrimitiveWrappers.add(Byte.class);
        PrimitiveWrappers.add(Short.class);
        PrimitiveWrappers.add(Character.class);
        PrimitiveWrappers.add(Integer.class);
        PrimitiveWrappers.add(Long.class);
        PrimitiveWrappers.add(Float.class);
        PrimitiveWrappers.add(Double.class);
        PrimitiveWrappers.add(Boolean.class);
        PrimitiveTypeMap = new HashMap();
        PrimitiveTypeMap.put("byte", Byte.TYPE);
        PrimitiveTypeMap.put("short", Short.TYPE);
        PrimitiveTypeMap.put("char", Character.TYPE);
        PrimitiveTypeMap.put("int", Integer.TYPE);
        PrimitiveTypeMap.put("long", Long.TYPE);
        PrimitiveTypeMap.put("float", Float.TYPE);
        PrimitiveTypeMap.put("double", Double.TYPE);
        PrimitiveTypeMap.put("boolean", Boolean.TYPE);
        JavaWrapperToPrimitiveMap = new HashMap();
        JavaWrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        JavaWrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        JavaWrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        JavaWrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        JavaWrapperToPrimitiveMap.put(String.class, String.class);
        JavaWrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        JavaWrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        PrimitiveToJavaWrapperMap = new HashMap();
        PrimitiveToJavaWrapperMap.put(Double.TYPE, Double.class);
        PrimitiveToJavaWrapperMap.put(Integer.TYPE, Integer.class);
        PrimitiveToJavaWrapperMap.put(Long.TYPE, Long.class);
        PrimitiveToJavaWrapperMap.put(Float.TYPE, Float.class);
        PrimitiveToJavaWrapperMap.put(String.class, String.class);
        PrimitiveToJavaWrapperMap.put(Boolean.TYPE, Boolean.class);
        PrimitiveToJavaWrapperMap.put(Character.TYPE, Character.class);
    }

    public static List<Field> retrieveAllFieldsFromClass(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            Field[] fieldFromThisClass = clazz.getDeclaredFields();
            fields.addAll(Arrays.asList(fieldFromThisClass));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return PrimitiveWrappers.contains(clazz) || PrimitiveTypeMap.values().contains(clazz);
    }

    public static int[] getDimensions(Object[] array) {
        String className = array.getClass().getName();
        int nbDimensions = className.lastIndexOf("[") + 1;
        int[] dimensions = new int[nbDimensions];
        Object current = array;
        int dim = 0;
        while (dim < nbDimensions) {
            dimensions[dim] = Array.getLength(current);
            current = Array.get(current, 0);
            ++dim;
        }
        return dimensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object convertArrayType(Object[] currentArray, Class<?> clazz) {
        if (currentArray == null || currentArray.length == 0) {
            throw new InvalidParameterException("The array is either null or empty!");
        }
        int[] dimensions = ReflectUtility.getDimensions(currentArray);
        Object newArray = Array.newInstance(clazz, dimensions);
        int i = 0;
        while (i < currentArray.length) {
            if (currentArray[i].getClass().isArray()) {
                Array.set(newArray, i, ReflectUtility.convertArrayType((Object[])currentArray[i], clazz));
            } else {
                Object currentValue = currentArray[i];
                if (PrimitiveToJavaWrapperMap.containsKey(clazz)) {
                    if (clazz.equals(Double.TYPE)) {
                        Array.set(newArray, i, ((Number)currentValue).doubleValue());
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.set(newArray, i, ((Number)currentValue).intValue());
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.set(newArray, i, ((Number)currentValue).longValue());
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.set(newArray, i, Float.valueOf(((Number)currentValue).floatValue()));
                    } else if (clazz.equals(String.class)) {
                        Array.set(newArray, i, currentValue.toString());
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.set(newArray, i, Character.valueOf(((Character)currentValue).charValue()));
                    } else {
                        if (!clazz.equals(Boolean.TYPE)) throw new InvalidParameterException("The primitive type is not recognized!");
                        Array.set(newArray, i, (boolean)((Boolean)currentValue));
                    }
                } else {
                    Array.set(newArray, i, clazz.cast(currentArray[i]));
                }
            }
            ++i;
        }
        return newArray;
    }
}

