% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pile}
\alias{pile}
\title{Get IDs of intervals covering each sub-interval}
\usage{
pile(x, interval_names = rownames(x), output = "list")
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points.}

\item{interval_names}{Character vector of names for each interval, not necessarily unique. If they are not unique, one might wish to \code{lapply} \code{unique} to the list of members for each sub-interval returned by this function. Defaults to the \code{rownames} of \code{x}.}

\item{output}{Character value either \code{"list"} or \code{"vector"} determining whether a named list of interval index/name vectors or flat vector of members (corresponding to the output of \code{\link{depth}}) is returned.}
}
\value{
See notes on \code{output} parameter.
}
\description{
Get the intervals overlapping each section as a list.
}
\examples{
pile(cbind(1:10, 11:20))
}
