/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length));
        this.assign(dArray);
    }

    public SparseDComplexMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new ConcurrentHashMap(n * n2 * (n3 / 1000));
    }

    protected SparseDComplexMatrix3D(int n, int n2, int n3, ConcurrentHashMap<Long, double[]> concurrentHashMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix3D assign(double[] dArray) {
        if (this.isNoView && dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int n, int n2, int n3) {
        double[] dArray = this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
        if (dArray != null) {
            return new double[]{dArray[0], dArray[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D instanceof SelectedSparseDComplexMatrix3D) {
            SelectedSparseDComplexMatrix3D selectedSparseDComplexMatrix3D = (SelectedSparseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == selectedSparseDComplexMatrix3D.elements;
        }
        if (dComplexMatrix3D instanceof SparseDComplexMatrix3D) {
            SparseDComplexMatrix3D sparseDComplexMatrix3D = (SparseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == sparseDComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    @Override
    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new SparseDComplexMatrix3D(n, n2, n3);
    }

    @Override
    public DComplexMatrix2D like2D(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseDComplexMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, dArray);
        }
    }

    @Override
    public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new double[]{d, d2});
        }
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseDComplexMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    @Override
    public DComplexMatrix1D vectorize() {
        SparseDComplexMatrix1D sparseDComplexMatrix1D = new SparseDComplexMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseDComplexMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseDComplexMatrix1D;
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        final SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SparseDComplexMatrix3D.this.columns; ++k) {
                                    sparseDoubleMatrix3D.setQuick(i, j, k, SparseDComplexMatrix3D.this.getQuick(i, j, k)[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, j, k, this.getQuick(i, j, k)[1]);
                    }
                }
            }
        }
        return sparseDoubleMatrix3D;
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        final SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SparseDComplexMatrix3D.this.columns; ++k) {
                                    sparseDoubleMatrix3D.setQuick(i, j, k, SparseDComplexMatrix3D.this.getQuick(i, j, k)[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, j, k, this.getQuick(i, j, k)[0]);
                    }
                }
            }
        }
        return sparseDoubleMatrix3D;
    }
}

