/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;

    public SparseFComplexMatrix3D(float[][][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, fArray.length == 0 ? 0 : (fArray[0].length == 0 ? 0 : fArray[0][0].length));
        this.assign(fArray);
    }

    public SparseFComplexMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new ConcurrentHashMap(n * n2 * (n3 / 1000));
    }

    protected SparseFComplexMatrix3D(int n, int n2, int n3, ConcurrentHashMap<Long, float[]> concurrentHashMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix3D assign(float[] fArray) {
        if (this.isNoView && fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public float[] getQuick(int n, int n2, int n3) {
        float[] fArray = this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
        if (fArray != null) {
            return new float[]{fArray[0], fArray[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Long, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D instanceof SelectedSparseFComplexMatrix3D) {
            SelectedSparseFComplexMatrix3D selectedSparseFComplexMatrix3D = (SelectedSparseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == selectedSparseFComplexMatrix3D.elements;
        }
        if (fComplexMatrix3D instanceof SparseFComplexMatrix3D) {
            SparseFComplexMatrix3D sparseFComplexMatrix3D = (SparseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == sparseFComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    @Override
    public FComplexMatrix3D like(int n, int n2, int n3) {
        return new SparseFComplexMatrix3D(n, n2, n3);
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    protected FComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseFComplexMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    public void setQuick(int n, int n2, int n3, float[] fArray) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public void setQuick(int n, int n2, int n3, float f, float f2) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseFComplexMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    @Override
    public FComplexMatrix1D vectorize() {
        SparseFComplexMatrix1D sparseFComplexMatrix1D = new SparseFComplexMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseFComplexMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseFComplexMatrix1D;
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        final SparseFloatMatrix3D sparseFloatMatrix3D = new SparseFloatMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseFComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SparseFComplexMatrix3D.this.columns; ++k) {
                                    sparseFloatMatrix3D.setQuick(i, j, k, SparseFComplexMatrix3D.this.getQuick(i, j, k)[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        ((FloatMatrix3D)sparseFloatMatrix3D).setQuick(i, j, k, this.getQuick(i, j, k)[1]);
                    }
                }
            }
        }
        return sparseFloatMatrix3D;
    }

    @Override
    public FloatMatrix3D getRealPart() {
        final SparseFloatMatrix3D sparseFloatMatrix3D = new SparseFloatMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseFComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SparseFComplexMatrix3D.this.columns; ++k) {
                                    sparseFloatMatrix3D.setQuick(i, j, k, SparseFComplexMatrix3D.this.getQuick(i, j, k)[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        ((FloatMatrix3D)sparseFloatMatrix3D).setQuick(i, j, k, this.getQuick(i, j, k)[0]);
                    }
                }
            }
        }
        return sparseFloatMatrix3D;
    }
}

