/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

class SelectedSparseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseObjectMatrix2D(int n, int n2, AbstractLongObjectMap abstractLongObjectMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractLongObjectMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected SelectedSparseObjectMatrix2D(AbstractLongObjectMap abstractLongObjectMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, abstractLongObjectMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int n, int n2) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D selectedSparseObjectMatrix2D = (SelectedSparseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedSparseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D sparseObjectMatrix2D = (SparseObjectMatrix2D)objectMatrix2D;
            return this.elements == sparseObjectMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, Object object) {
        long l = (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (object == null) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, object);
        }
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D sparseObjectMatrix1D = new SparseObjectMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseObjectMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseObjectMatrix1D;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    public ObjectMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseObjectMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public ObjectMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseObjectMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseObjectMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

