/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DTest;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;

public class SparseDoubleMatrix2DTest
extends DoubleMatrix2DTest {
    public SparseDoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseDoubleMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testGetRowCompressed() {
        int n;
        int n2;
        int n3 = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = sparseDoubleMatrix2D.getRowCompressed(false);
        for (n2 = 0; n2 < sparseDoubleMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseDoubleMatrix2D.columns(); ++n) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(n2, n), (Object)sparseRCDoubleMatrix2D.getQuick(n2, n));
            }
        }
        sparseRCDoubleMatrix2D = sparseDoubleMatrix2D.getRowCompressed(true);
        for (n2 = 0; n2 < sparseDoubleMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseDoubleMatrix2D.columns(); ++n) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(n2, n), (Object)sparseRCDoubleMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetRowCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, dArray);
        SparseRCMDoubleMatrix2D sparseRCMDoubleMatrix2D = sparseDoubleMatrix2D.getRowCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)sparseRCMDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testGetColumnCompressed() {
        int n;
        int n2;
        int n3 = this.A.rows() * this.A.columns();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, dArray);
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = sparseDoubleMatrix2D.getColumnCompressed(false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(n2, n), (Object)sparseCCDoubleMatrix2D.getQuick(n2, n));
            }
        }
        sparseCCDoubleMatrix2D = sparseDoubleMatrix2D.getColumnCompressed(true);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(n2, n), (Object)sparseCCDoubleMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetColumnCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, dArray);
        SparseCCMDoubleMatrix2D sparseCCMDoubleMatrix2D = sparseDoubleMatrix2D.getColumnCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)sparseCCMDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testAssignIntArrayIntArrayDoubleArrayDoubleDoubleFunction() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns());
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.A.rows();
            nArray2[i] = i % this.A.columns();
            dArray[i] = Math.random();
            ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(nArray[i], nArray2[i], dArray[i]);
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.A.rows(), this.A.columns());
        sparseDoubleMatrix2D.assign(nArray, nArray2, dArray, DoubleFunctions.multSecond(2.0));
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)(2.0 * ((DoubleMatrix2D)denseDoubleMatrix2D).getQuick(i, j)), (Object)sparseDoubleMatrix2D.getQuick(i, j));
            }
        }
    }
}

