% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHawkes.R
\name{simHawkes1a}
\alias{simHawkes1a}
\title{Simulate an (inhomogeneous) Hawkes self-exciting process
\code{simHawkes1a} simulates the event times of an inhomogeneous
Hawkes process (IHSEP) with background event intensity/rate
\eqn{nu(\cdot)\geq 0}, branching ratio \eqn{\eta\in[0,1)}, and
offspring birthtime density \eqn{g(\cdot)}, up to a censoring time
\eqn{T}.}
\usage{
simHawkes1a(
  nu = function(x) rep(100, length(x)),
  cens = 1,
  nuM = max(optimize(nu, c(0, cens), maximum = TRUE)$obj, nu(0), nu(cens),
    .Machine$double.eps^0.5) * 1.1,
  br = 0.5,
  dis = "exp",
  par.dis = list(rate = 1)
)
}
\arguments{
\item{nu}{a function, which gives the background event intensity
function \eqn{\nu(\cdot)}; needs to be a bounded function on
\eqn{[0,T]}.}

\item{cens, }{a positive scalar, which gives the censoring time.}

\item{nuM, }{positive scalar, optional argument giving the maximum
of the background intensity function on \eqn{[0,T]}.}

\item{br, }{scalar in [0,1), giving the branching ratio.}

\item{dis, }{character string giving the name of the child birthtime
distribution; 'd${dis}' gives the density function \eqn{g(\cdot)}.}

\item{par.dis, }{a (named) list giving the values of the parameters of the child birthtime distribution.}
}
\value{
a vector giving the event times of an inhomogeneous Hawkes process up to the censoring time in ascending order.
}
\description{
Simulate an (inhomogeneous) Hawkes self-exciting process
\code{simHawkes1a} simulates the event times of an inhomogeneous
Hawkes process (IHSEP) with background event intensity/rate
\eqn{nu(\cdot)\geq 0}, branching ratio \eqn{\eta\in[0,1)}, and
offspring birthtime density \eqn{g(\cdot)}, up to a censoring time
\eqn{T}.
}
