% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{ReadAndSplitStrelkaSBSVCFs}
\alias{ReadAndSplitStrelkaSBSVCFs}
\title{\strong{[Deprecated, use ReadAndSplitVCFs(variant.caller = "strelka") instead]}
Read and split Strelka SBS VCF files}
\usage{
ReadAndSplitStrelkaSBSVCFs(
  files,
  names.of.VCFs = NULL,
  suppress.discarded.variants.warnings = TRUE
)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka SBS VCF files.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCF
file paths in \code{files}. If \code{NULL}(default), this function will
remove all of the path up to and including the last path separator (if any)
in \code{files} and file paths without extensions (and the leading dot)
will be used as the names of the VCF files.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\description{
\strong{[Deprecated, use ReadAndSplitVCFs(variant.caller = "strelka") instead]}
The function will find and merge adjacent SBS pairs into DBS if their VAFs
are very similar. The default threshold value for VAF is 0.02.
}
\section{Value}{

A list of elements as follows:
\itemize{
\item \code{SBS.vcfs}: List of data.frames of pure SBS mutations -- no DBS or
3+BS mutations.
\item \code{DBS.vcfs}: List of data.frames of pure DBS mutations -- no SBS or
3+BS mutations.
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
}
}

\examples{
\dontrun{
file <- c(system.file("extdata/Strelka-SBS-vcf",
                      "Strelka.SBS.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitStrelkaSBSVCFs(file)
}
}
\seealso{
\code{\link{StrelkaSBSVCFFilesToCatalog}}
}
