% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{compQ}
\alias{compQ}
\alias{compQ,distributionH,numeric-method}
\alias{compQ,distributionH-method}
\title{Method \code{compQ}}
\usage{
compQ(object, p)

\S4method{compQ}{distributionH,numeric}(object, p)
}
\arguments{
\item{object}{an object of \env{distributionH} class}

\item{p}{a number between 0 and 1}
}
\value{
\deqn{y= F^{-1}(p)=Q(p)} A number that is the quantile of the passed
histogram \env{object} at level \env{p}.
}
\description{
Compute the quantile value of a histogram for a given probability.
}
\examples{

##---- A mydist distribution ----
mydist<-distributionH(x=c(1,2,3,10), p=c(0,0.1,0.5,1))
##---- Compute the quantile of mydist for different values of p ----
y<-compQ(mydist,0.5) #the median
y<-compQ(mydist,0) #the minimum
y<-compQ(mydist,1) #the maximum
y<-compQ(mydist,0.25) #the first quartile
y<-compQ(mydist,0.9) #the ninth decile

}
\author{
Antonio Irpino
}
