% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WriteObs}
\alias{WriteObs}
\alias{WritePTQobs}
\title{Write 'Pobs.txt', 'Tobs.txt', 'Qobs.txt', and other observation data files}
\usage{
WriteObs(
  x,
  filename,
  dt.format = "\%Y-\%m-\%d",
  round = NULL,
  signif = NULL,
  obsid = NULL,
  append = FALSE
)

WritePTQobs(
  x,
  filename,
  dt.format = "\%Y-\%m-\%d",
  round = NULL,
  signif = NULL,
  obsid = NULL,
  append = FALSE
)
}
\arguments{
\item{x}{The object to be written, a \code{dataframe} containing observation date-times in first and observations in SUBIDs or OBSIDs in
remaining columns. If argument \code{obsid} is not provided, \code{x} must have an additional attribute \code{obsid} containing
observation IDs/SUBIDs in column order.}

\item{filename}{Path to and file name of the file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{dt.format}{Date-time \code{format} string as in \code{\link{strptime}}.}

\item{round, signif}{Integer, number of decimal places and number of significant digits to export, respectively. See \code{\link{round}} and \code{\link{signif}}. Applied in
sequence (\code{round} first and \code{signif} second). If \code{NULL} (default), the data to export is not touched.}

\item{obsid}{Integer vector containing observation IDs/SUBIDs in same order as columns in \code{x}. To be exported as header
in the obs file. Must contain the same number of IDs as observation series in \code{x}. If \code{NULL}, an attribute \code{obsid}
in \code{x} is mandatory. An existing \code{obsid} argument takes precedence over a \code{obsid} attribute.}

\item{append}{Logical, if \code{TRUE}, then table will be joined to the data in existing file and the output will be sorted by DATE (Rows will be added for any missing dates).}
}
\value{
No return value, called for export to text files.
}
\description{
Export forcing data and discharge observation files from R.
}
\details{
\code{WriteObs} is a convenience wrapper function of \code{\link[data.table]{fwrite}} to export a HYPE-compliant observation file.
Headers are generated from attribute \code{obsid} on export (see \code{\link{attr}} on how to create and access it).

Observation IDs are SUBIDs or IDs connected to SUBIDs with a
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:forckey.txt}{ForcKey.txt file}.

If the first column in \code{x} contains dates of class \code{POSIXt}, then they will be formatted according to \code{dt.format} before writing the output file.

If \code{round} is specified, then \code{WriteObs()} will use \code{\link{round}} to round the observation values to a specified number of decimal places.
Alternatively, \code{signif} can be used to round the observation values to a specified number of significant digits using \code{\link{signif}}.
Finally, if both \code{round} and \code{signif} are specified, then the observation values will be first rounded to the number of decimal places specified
with \code{round} and then rounded to the number of significant digits specified with \code{signif}.
}
\examples{
te <- ReadObs(filename = system.file("demo_model", "Tobs.txt", package = "HYPEtools"))
WriteObs(x = te, filename = tempfile())

}
\seealso{
\code{\link{ReadObs}}
\code{\link{WriteXobs}}
}
