% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.L.r
\name{mask.L}
\alias{mask.L}
\title{Mask L likelihood}
\usage{
mask.L(pred.t, L.t, lon, lat, par0, bound.thr = 0.05, minBounds = NULL)
}
\arguments{
\item{pred.t}{is prediction at t-1 that is used for 1) the size of the mask 
and 2) multiplying with L for resulting post likelihood surface}

\item{L.t}{is data based likelihood layer, L[t], for the time step of
interest (usually a day)}

\item{lon}{vector of longitude values corresponding to dims of the previous 2
layers}

\item{lat}{vector of latitude values corresponding to dims of the previous 2
layers}

\item{par0}{is vector of movement parameter values, likely output from
\code{calc.param}.}

\item{bound.thr}{is numeric indicating the percent threshold that is added 
and subtracted from the bounding box of the filter output from the 
previous day before masking. Default is .05 (5 percent).}

\item{minBounds}{is size (in degrees) of the minimum bounding box around the 
previous days filter prediction that L data within that box will be 
included. Outside this box (centered on t-1 filter prediction), L will be 
masked out.}
}
\value{
post matrix as a product of the input prediction and L values
}
\description{
\code{mask.L} masks L likelihood based on a certain extent from previous days
filter prediction
}
\details{
L likelihood is masked based on a percent size (in addition to) the extent of
the previous days prediction kernel. If that kernel is smaller than the 
migratory kernel being used, the migratory kernel size is defaulted to. User 
can also specify a minimum bound size.
}
