% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.srss.r
\name{calc.srss}
\alias{calc.srss}
\title{Calculate Position-based Likelihood from SRSS}
\usage{
calc.srss(light = NULL, locs.grid, dateVec, res = 1, focalDim = 3)
}
\arguments{
\item{light}{is data frame from -LightLoc file output from DAP/Tag Portal for WC tags and 
contains tag-measured dawn/dusk times.}

\item{locs.grid}{is list output from \code{setup.locs.grid}}

\item{dateVec}{is vector of dates from tag to pop-up in 1 day increments.}

\item{res}{is resolution of light grid in degrees. default is 1 deg. higher
resolution (e.g. res = .25 for 1/4 deg) takes considerably longer to
compute}

\item{focalDim}{is integer for dimensions of raster::focal used to calculate 
sd() of SRSS grid cell. Recommend focalDim = 3 if res=1 and focalDim = 9 if
res=0.25.}
}
\value{
L is a raster of dim(lon x lat x dateVec) containing likelihood
  surfaces for each time point
}
\description{
\code{calc.srss} calculates likelihood estimates for each day's estimated
dawn dusk times from the tag
}
\details{
Tag-measured sunrise/sunset (SRSS) times are first filtered according to the
min/max times possible. possible values are computed based on spatial limits
included in locs.grid input. after filtering, each yearday has a grid of
georeferenced SRSS times that the tag-measured times are compared to in order
to generate a likelihood.
}
\seealso{
\code{\link{calc.gpe2}}
}
