% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHMD.R
\name{readCHMDweb}
\alias{readCHMDweb}
\title{read data from the Canadian Human Mortality Database into R}
\usage{
readCHMDweb(provID = "can", item = "Deaths_1x1", fixup = TRUE, ...)
}
\arguments{
\item{provID}{a single provID 3 character string, as returned by \code{getCHMDprovinces()}.}

\item{item}{the statistical product you want, e.g., \code{"fltper_5x5"}. Only 1.}

\item{fixup}{logical. Should columns be made more user-friendly, e.g., forcing Age to be integer?}

\item{...}{extra arguments ultimately passed to \code{read.table()}. Not likely needed.}
}
\value{
\code{data.frame} of the data item is invisibly returned
}
\description{
CHMD data are formatted exactly as HMD data. This function simply parses the necessary url together given a province code and data item (same nomenclature as HMD). Data is parsed using \code{HMDparse()}, which converts columns into useful and intuitive classes, for ready-use. See \code{?HMDparse} for more information on type conversions. No authentication is required for this database. Only a single item/prefecture is downloaded. Loop for more complex calls (See examples). The provID is not appended as a column, so be mindful of this if appending several items together into a single \code{data.frame}. Note that at the time of this writing, the finest Lexis resolution for prefectural lifetables is 5x5 (5-year, 5-year age groups). Raw data are, however, provided in 1x1 format, and deaths are also available in triangles. Note that cohort data are not produced for Canada at this time (but you could produce such data by starting with the \code{Deaths\_Lexis} file...).
}
\details{
This database is curated independently from the HMD/HFD family, and so file types and locations may be subject to change. If this happens, please notify the package maintainer.
}
\examples{
\dontrun{
library(HMDHFDplus)
# grab province codes (including All Canada)
provs <- getCHMDprovinces()
# grab all mltper_5x5  
# and stick into long data.frame: 
mltper <- do.call(rbind, lapply(provs, function(provID){
                   Dat        <- readCHMDweb(provID = provID, item = "mltper_5x5", fixup = TRUE)
                   Dat$provID <- provID
                   Dat
}))
}

}
