% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descens.R
\name{DESCENS}
\alias{DESCENS}
\alias{descens.threshold}
\alias{descens.threshold.free}
\alias{descens.weighted.threshold.free}
\alias{descens.weighted.threshold}
\alias{descens.tau}
\title{DESCENS variants}
\usage{
descens.threshold(S, g, root = "00", t = 0.5)

descens.threshold.free(S, g, root = "00")

descens.weighted.threshold.free(S, g, root = "00", w = 0.5)

descens.weighted.threshold(S, g, root = "00", t = 0.5, w = 0.5)

descens.tau(S, g, root = "00", t = 0.5)
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes}

\item{root}{name of the class that it is on the top-level of the hierarchy (\code{def. root="00"})}

\item{t}{threshold for the choice of the positive descendants (\code{def. t=0.5}); whereas in the \code{descens.tau} variant 
the parameter \code{t} balances the contribution between the positives children of a node \eqn{i} and that of its
positives descendants excluding the positives children}

\item{w}{weight to balance between the contribution of the node \eqn{i} and that of its positive descendants}
}
\value{
a named matrix with the scores of the classes corrected according to the DESCENS algorithm.
}
\description{
The novelty of DESCENS with respect to TPR-DAG algorithm consists in considering the contribution of all the descendants 
of each node instead of only that of its children, since with the TPR-DAG algorithm the contribution of the descendants of a given node 
decays exponentially with their distance from the node itself, thus reducing the impact of the predictions made at the most specific levels of the ontology. 
On the contrary DESCENS predictions are more influenced by the information embedded in the most specific terms of the taxonomy (e.g. leaf nodes), 
thus putting more emphasis on the terms that most characterize the gene under study.
}
\details{
The \emph{vanilla} DESCENS adopts a per-level bottom-up traversal of the DAG to correct the flat predictions \eqn{\hat{y}_i}:
\deqn{
	\bar{y}_i := \frac{1}{1 + |\Delta_i|} (\hat{y}_i + \sum_{j \in \Delta_i} \bar{y}_j)
}
where \eqn{\Delta_i} are the positive descendants of \eqn{i}.
Different strategies to select the positive descendants \eqn{\Delta_i} can be applied:
\enumerate{
	\item \strong{Threshold-Free} strategy: as positive descendants we choose those nodes that achieve a score higher than that of their ancestor node \eqn{i}:
	\deqn{
		\Delta_i := \{ j \in descendats(i) | \bar{y}_j > \hat{y}_i \}
	}
	\item \strong{Threshold} strategy: the positive descendants are selected on the basis of a threshold that can ben selected in two different ways:
	\enumerate{
		\item for each node a constant threshold \eqn{\bar{t}} is a priori selected:
	\deqn{
		\phi_i := \{ j \in descendats(i) | \bar{y}_j > \bar{t} \}
	}
		For instance if the predictions represent probabilities it could be meaningful to a priori select \eqn{\bar{t}=0.5}.
		\item the threshold is selected to maximize some performance metric \eqn{\mathcal{M}} estimated on the training data, as for instance
		the F-score or the AUPRC. In other words the threshold is selected to maximize some measure of accuracy of the predictions 
		\eqn{\mathcal{M}(j,t)} on the training data for the class \eqn{j} with respect to the threshold \eqn{t}. 
		The corresponding set of positives \eqn{\forall i \in V} is:
		\deqn{
			\phi_i := \{ j \in descendants(i) | \bar{y}_j > t_j^*,  t_j^* = \arg \max_{t} \mathcal{M}(j,t) \}
		}
		For instance \eqn{t_j^*} can be selected from a set of \eqn{t \in (0,1)} through internal cross-validation techniques.
}
}
The weighted DESCENS variants can be simply designed by adding a weight \eqn{w \in [0,1]} to balance the contribution between 
the prediction of the classifier associated with the node \eqn{i} and that of its positive descendants:
\deqn{
	\bar{y}_i := w \hat{y}_i + \frac{(1 - w)}{|\Delta_i|} \sum_{j \in \phi_i} \bar{y}_j
}
The DESCENS-\eqn{\tau} variants balances the contribution between the positives children of a node \eqn{i} and that of
its positives descendants excluding the children by adding a weight \eqn{\tau \in [0,1]}:
\deqn{
\bar{y}_i := \frac{\tau}{ 1 +|\phi_i|} ( \hat{y}_i + \sum_{j \in \phi_i} \bar{y}_j ) + \frac{1-\tau}{1+|\delta_i|} ( \hat{y}_i + \sum_{j\in \delta_i} \bar{y}_j )
}
where \eqn{\phi_i} are the positive children of \eqn{i} and \eqn{\delta_i=\Delta_i \setminus \phi_i} the descendants of \eqn{i} without its children. 
If \eqn{\tau=1} we consider only the contribution of the positive children of \eqn{i}; if \eqn{\tau=0} only the descendants that are not
children contribute to the score, while for intermediate values of \eqn{\tau} we can balance the contribution of \eqn{\phi_i} and 
\eqn{\delta_i} positive nodes.
}
\examples{
data(graph);
data(scores);
data(labels);
root <- root.node(g);
S.descensTF <- descens.threshold.free(S,g,root);
S.descensT <- descens.threshold(S,g,root,t=0.5);
S.descensW <- descens.weighted.threshold.free(S,g,root,w=0.5);
S.descensWT <- descens.weighted.threshold(S,g,root,w=0.5, t=0.5);
S.descensTAU <- descens.tau(S,g,root, t=0.5);
}
\seealso{
\code{\link{TPR-DAG}}
}
