% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_run_clustering.R
\name{Run_Clustering}
\alias{Run_Clustering}
\title{Launch parallel clustering}
\usage{
Run_Clustering(
  data_clustering,
  ploidy,
  save_n = "",
  n_iter = 5,
  D_min = 0.22,
  n_core = 1,
  path_log = ""
)
}
\arguments{
\item{data_clustering}{dataframe result from create dataset phase}

\item{ploidy}{ploidy of offspring}

\item{save_n}{name of the saving file}

\item{n_iter}{number of iterations of clustering}

\item{D_min}{threshold distance between two clusters}

\item{n_core}{number of cores used for parallelization}

\item{path_log}{path for log file when run by the shiny app}
}
\value{
the result of clustering or automatically save a list of objects if a saving name has been provided
}
\description{
Launch the clustering phase in parallel from the dataset with SampleName, Contrast and SigStren for each markers.
}
\examples{

data(GenoTriplo_to_clust)
res = Run_Clustering(data_clustering=GenoTriplo_to_clust,
                     ploidy=3,n_iter=5,n_core=1)
# or if you want to automatically save the result
# This will automatically create a folder and save the result in it
# Run_Clustering(data_clustering=GenoTriplo_to_clust,
#                ploidy=3,n_iter=5,n_core=1,save_n='exemple')


}
