% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSizeTTE}
\alias{getSizeTTE}
\title{General Formulas for Sample Size Calculation}
\usage{
getSizeTTE(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  varlambda,
  k = 1,
  ttotal,
  taccrual,
  gamma,
  delta = 0,
  rho = c(0.05, 0.07),
  r = 0.1
)
}
\arguments{
\item{design}{allocation method (\code{parallel} or \code{crossover}).}

\item{test}{four hypothesis tests: \code{equality}, \code{noninferiority}, \code{superiority}, and \code{equivalence}.}

\item{alpha}{level of significance.}

\item{beta}{type II error.}

\item{varlambda}{(varlambda1>0,varlambda2>0):=(lam1,lam2) hazard rates in control and treatment arms}

\item{k}{ratio of control to treatment.}

\item{ttotal}{total trial time (ttoal>0)}

\item{taccrual}{accrual time period (taccrual>0)}

\item{gamma}{parameter of exponential distribution (gamma>=0)}

\item{delta}{delta margin in test hypothesis.}

\item{rho}{vector of length 2, positive noncompliance rates of two arms.}

\item{r}{projected proportion of trial uniform loss of follow-up.}
}
\value{
sample size per arm.
}
\description{
This function computes the sample size required for two arms clinical trials with TTE outcome measure. Four hypothesis tests are available under two allocation designs.
}
\examples{
# Ex 1. (n_trt=56, n_ctl=56)
getSizeTTE(design="parallel", test="equality", alpha=0.05, beta=0.20,
 varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0,
 rho=c(0.05, 0.07), r=0.1)

# Ex 2. (n_trt=30, n_ctl=30)
getSizeTTE(design="parallel", test="noninferiority", alpha=0.05, beta=0.20,
 varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta= -0.2,
 rho=c(0.05, 0.07), r=0.1)

# Ex 3. (n_trt=74, n_ctl=74)
getSizeTTE(design="parallel", test="superiority", alpha=0.05, beta=0.20,
varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.20,
rho=c(0.05, 0.07), r=0.1)

# Ex 4. (n_trt=84, n_ctl=84)
getSizeTTE(design="parallel", test="equivalence", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 5. (Check back next version)
getSizeTTE(design="crossover", test="equality", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 6. (Check back next version)
getSizeTTE(design="crossover", test="noninferiority", alpha=0.05,
 beta=0.20, varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001,
 delta=0.5, rho=c(0.05, 0.07), r=0.1)

# Ex 7. (Check back next version)
getSizeTTE(design="crossover", test="superiority", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 8. (Check back next version)
getSizeTTE(design="crossover", test="equivalence", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

}
