% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/makeGRANRepos.R
\docType{methods}
\name{makeRepo}
\alias{makeRepo}
\alias{makeRepo,PkgManifest-method}
\alias{makeRepo,PkgManifest}
\alias{makeRepo,SessionManifest-method}
\alias{makeRepo,SessionManifest}
\alias{makeRepo,GRANRepository-method}
\alias{makeRepo,GRANRepository}
\alias{makeRepo,character-method}
\alias{makeRepo,character}
\title{makeRepo}
\usage{
makeRepo(x, cores = (parallel:::detectCores() - 1), build_pkgs = NULL,
  scm_auth = list(bioconductor.org = c("readonly", "readonly")), ...)

\S4method{makeRepo}{PkgManifest}(x, cores = (parallel:::detectCores() - 1),
  build_pkgs = NULL, scm_auth = list(bioconductor.org = c("readonly",
  "readonly")), ...)

\S4method{makeRepo}{SessionManifest}(x, cores = (parallel:::detectCores() -
  1), build_pkgs = NULL, scm_auth = list(bioconductor.org = c("readonly",
  "readonly")), ...)

\S4method{makeRepo}{GRANRepository}(x, cores = (parallel:::detectCores() - 1),
  build_pkgs = NULL, scm_auth = list(bioconductor.org = c("readonly",
  "readonly")), ...)

\S4method{makeRepo}{character}(x, cores = (parallel:::detectCores() - 1),
  build_pkgs = NULL, scm_auth = list(bioconductor.org = c("readonly",
  "readonly")), ...)
}
\arguments{
\item{x}{The object containing the information necessary to create the repository}

\item{cores}{The number of cores on the local machine to use during building}

\item{build_pkgs}{The names of the packages to (re) build and test within the
repository. Defaults to \code{NULL} which builds all packages in the manifest}

\item{scm_auth}{A named list containing the information necessary to check
out package sources. The list elements (assumed to be a character vector of
length 2, user then password) are applied when the name is contained in a
package's url}

\item{...}{Additional arguments, typically used for the construction of a
\code{GRANRepository} object if one does not already exist.}
}
\value{
A GRANRepository object which has used to create a repository.
}
\description{
Make a package repository containing a specified set of packages from
various sources
}
\references{
Becker G, Barr C, Gentleman R, Lawrence M; Enhancing Reproducibility and Collaboration via Management of R Package Cohorts. Journal of Statistical Software, 81(1). 2017. doi: 10.18637/jss.v082.i01
}
