% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_species_lookup.R
\name{GIFT_species_lookup}
\alias{GIFT_species_lookup}
\title{Species list in GIFT}
\usage{
GIFT_species_lookup(
  genus = "",
  epithet = "",
  namesmatched = FALSE,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{genus}{character string defining the genus name to be looked for.}

\item{epithet}{character string defining the specific epithet to be looked
for.}

\item{namesmatched}{Logical \code{FALSE} by default, set to \code{TRUE} if you want
to look for the species not only in the standardized species names but also
in the original species names as they came in the original resources.}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 19 columns (or 24 if namesmatched = TRUE).
}
\description{
Retrieve all name matching information for one taxonomic name. All results
are returned, where the name is either found in the unstandardized or
taxonomically standardized names.
}
\details{
Here is what each column refers to:
\emph{orig_ID} - Identification number of the species before taxonomic
harmonization\cr
\emph{orig_genus} - Genus before taxonomic harmonization\cr
\emph{name_ID} - Identification number of the genus before taxonomic
harmonization\cr
\emph{cf_genus}- Whether the genus name is uncertain\cr
\emph{genus}- Genus before taxonomic harmonization\cr
\emph{cf_species}- Whether the species' epithet is uncertain\cr
\emph{aff_species}- Species' epithet uncertain\cr
\emph{species_epithet}- Epithet of the species before taxonomic
harmonization\cr
\emph{subtaxon}- Subtaxon of the species before taxonomic harmonization\cr
\emph{author}- Author who described the species (before taxonomic
harmonization)\cr
\emph{matched}- Is the species matched in the taxonomic backbone\cr
\emph{epithetscore}- Matching score for the epithet\cr
\emph{overallscore}- Overall matching score for the species\cr
\emph{resolved}- Is the species name resolved in the taxonomic backbone\cr
\emph{synonym}- Is the species name a synonym in the taxonomic backbone\cr
\emph{matched_subtaxon}- Is the subtaxon matched in the taxonomic backbone\cr
\emph{accepted}- Is the species name accepted in the taxonomic backbone\cr
\emph{service}- Service use for the taxonomic harmonization\cr
\emph{work_ID}- Identification number of the species after taxonomic
harmonization\cr
\emph{taxon_ID}- Identification number of the taxonomic group\cr
\emph{work_genus}- Identification number of the genus after taxonomic
harmonization\cr
\emph{work_species_epithet}- Identification number of the species epithet
after taxonomic harmonization\cr
\emph{work_species} - Species name (after taxonomic harmonization)\cr
\emph{work_author}-  Author who described the species (after taxonomic
harmonization)
}
\examples{
\donttest{
ex <- GIFT_species_lookup(genus = "Fagus", epithet = "sylvatica")
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
