% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intertemporal_utility.R
\name{intertemporal_utility}
\alias{intertemporal_utility}
\title{Intertemporal Utility Function}
\usage{
intertemporal_utility(x, beta = 1, gamma = 1)
}
\arguments{
\item{x}{a vector consists of the instantaneous utility levels of some periods.}

\item{beta}{the discount factor.}

\item{gamma}{the coefficient (>=0) in CRRA instantaneous utility function.}
}
\value{
A list consists of the intertemporal utility level and the certainty-equivalent instantaneous utility level (i.e. steady-state-equivalent instantaneous utility level).
}
\description{
An intertemporal utility function with constant relative risk aversion.
}
\examples{
\donttest{
intertemporal_utility(c(1, 2, 3), beta = 0.99, gamma = 0.5)
intertemporal_utility(c(1, 2, 3) / 10, beta = 0.99, gamma = 0.5)
intertemporal_utility(c(1, 2, 3) / 10, gamma = 0)
}

}
